package org.semanticweb.owl.modularity;

import org.semanticweb.owl.model.*;

import java.net.URI;
import java.util.Set;

/**
 * An interface for any class implementing a segment or module of an ontology.
 *
 * @author Thomas Schneider
 * @author School of Computer Science
 * @author University of Manchester
 */
public interface OntologySegment {

    /**
     * Returns the set of axioms that this segment consists of.
     * @return the segment as a set of axioms
     */
    public abstract Set<OWLAxiom> getAxioms();

    /**
     * Returns the set of logical axioms in this segment.
     * @return all logical axioms in this segment
     */
    public abstract Set<OWLAxiom> getLogicalAxioms();

    /**
     * Returns the set of non-logical axioms in this segment.
     * @return all non-logical axioms in this segment
     */
    public abstract Set<OWLAxiom> getNonLogicalAxioms();

    /**
     * Returns the signature (set of entities) for which this segment has been extracted.
     * @return the seed signature as a set of entities
     */
    public abstract Set<OWLEntity> getSeedSignature();

    /**
     * Returns the signature of this segment, i.e. the set of entities that occur in it.
     * @return the signature as a set of entities
     */
    public abstract Set<OWLEntity> getSignature();

    /**
     * Returns this segment as a new ontology.
     * @param uri the URI for the new ontology
     * @return the new ontology, having the specified URI 
     * @throws OWLOntologyCreationException  if the new ontology cannot be created
     * @throws OWLOntologyChangeException    if adding axioms to the new ontology fails
     */
    public abstract OWLOntology asOWLOntology(URI uri) throws OWLOntologyCreationException, OWLOntologyChangeException;
}
