package org.coode.owl.rdfxml.parser;

import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

import java.net.URI;
import java.util.List;

public class TPPropertyChainAxiomHandler extends TriplePredicateHandler {

    public TPPropertyChainAxiomHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_PROPERTY_CHAIN_AXIOM.getURI());
    }

    @Override
    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        return false;
    }

    @Override
    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        List<OWLObjectPropertyExpression> subList = getConsumer().translateToObjectPropertyList(object);
        OWLObjectPropertyExpression superProperty = translateObjectProperty(subject);
        addAxiom(getDataFactory().getOWLObjectPropertyChainSubPropertyAxiom(subList, superProperty));
        consumeTriple(subject, predicate, object);
    }

}
