package org.coode.owl.rdfxml.parser;

import java.net.URI;

import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class TypeNegativePropertyAssertionHandler extends BuiltInTypeHandler {

    public TypeNegativePropertyAssertionHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getURI());
    }

    @Override
    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        return false;
    }

    @Override
    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        consumeTriple(subject, predicate, object);
        final URI sourceIndividualURI = getConsumer().getResourceObject(subject,
                OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL.getURI(), true);
        if( sourceIndividualURI == null ) {
            throw new OWLRDFXMLParserMalformedNodeException("missing owl:sourceIndividual triple");
        }
        final OWLIndividual sourceIndividual = translateIndividual(sourceIndividualURI);
        final URI assertionPropertyURI = getConsumer().getResourceObject(subject,
                OWLRDFVocabulary.OWL_ASSERTION_PROPERTY.getURI(), true);
        if( assertionPropertyURI == null ) {
            throw new OWLRDFXMLParserMalformedNodeException("missing owl:assertionProperty triple");
        }
        URI targetIndividualURI = getConsumer().getResourceObject(subject,
                OWLRDFVocabulary.OWL_TARGET_INDIVIDUAL.getURI(), true);
        OWLConstant targetValue = getConsumer().getLiteralObject(subject,
                OWLRDFVocabulary.OWL_TARGET_VALUE.getURI(), true);
        OWLAxiom ax;
        if( targetIndividualURI != null ) {
            if( targetValue != null ) {
                throw new OWLRDFXMLParserMalformedNodeException(
                        "owl:targetIndividual and owl:targetValue triples with the same subject");
            }
            final OWLObjectPropertyExpression assertionProperty = translateObjectProperty(assertionPropertyURI);
            final OWLIndividual targetIndividual = translateIndividual(targetIndividualURI);
            ax = getDataFactory().getOWLNegativeObjectPropertyAssertionAxiom(sourceIndividual,
                    assertionProperty, targetIndividual);
        }
        else {
            if( targetValue == null ) {
                throw new OWLRDFXMLParserMalformedNodeException(
                        "missing owl:targetIndividual or owl:targetValue triple");
            }
            final OWLDataPropertyExpression assertionProperty = translateDataProperty(assertionPropertyURI);
            ax = getDataFactory().getOWLNegativeDataPropertyAssertionAxiom(sourceIndividual,
                    assertionProperty, targetValue);
        }
        addAxiom(ax);
        getConsumer().addReifiedAxiom(subject, ax);
    }

}
