/* Generated By:JavaCC: Do not edit this line. OWLFunctionalSyntaxParser.java */
package org.coode.owl.functionalparser;

import org.coode.string.EscapeUtils;
import org.semanticweb.owl.model.*;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.*;

public class OWLFunctionalSyntaxParser implements OWLFunctionalSyntaxParserConstants {

    private OWLOntologyManager man;

    private OWLOntology ontology;

    private OWLDataFactory dataFactory;

    private Map<String, URI> string2URI;

    private Map<String, String> prefixMap;

    private URI ontologyURI;

    private boolean ignoreAnnotationsAndDeclarations = false;

    private Set<OWLAnnotation> currentAnnotations;

    public void setUp(OWLOntologyManager man, OWLOntology ontology) {
        this.man = man;
        this.ontology = ontology;
        this.dataFactory = man.getOWLDataFactory();
        this.currentAnnotations = new HashSet<OWLAnnotation>();
        if(prefixMap == null) {
            prefixMap = new HashMap<String, String>();
        }
        string2URI = new HashMap<String, URI>();
    }

    public URI getURI(String s) throws URISyntaxException {
        URI uri = string2URI.get(s);
        if(uri == null) {
            if(s.charAt(0) == '<') {
                uri = new URI(s.substring(1, s.length() - 1));
            }
            else {
                uri = new URI(s);
            }
            string2URI.put(s, uri);
        }
        return uri;
    }

    public void setIgnoreAnnotationsAndDeclarations(boolean b) {
        ignoreAnnotationsAndDeclarations = b;
    }

    protected void applyChange(OWLOntologyChange chg) {
        try {
            man.applyChange(chg);
        }
        catch(OWLOntologyChangeException e) {
            e.printStackTrace();
        }
    }

    protected void addAxiom(OWLAxiom ax) {
        AddAxiom addAxiom = new AddAxiom(ontology, ax);
        applyChange(addAxiom);
    }

    public void setNamespaces(NamespaceManager nsm) {
        if(prefixMap == null) {
            prefixMap = new HashMap<String, String>();
        }
        prefixMap.putAll(nsm.getNamespaceMap());
    }

  final public void parse() throws ParseException, OWLOntologyCreationException {
    label_1:
    while (true) {
      if (jj_2_1(2)) {
        ;
      } else {
        break label_1;
      }
      Namespace();
    }
    Ontology();
    jj_consume_token(0);
  }

  final public void Ontology() throws ParseException, OWLOntologyCreationException {
    OWLAnnotation anno;
    OWLAxiom ax;
    int count = 0;
    jj_consume_token(ONTOLOGY);
    jj_consume_token(OPENPAR);
    ontologyURI = URI();
            applyChange(new SetOntologyURI(ontology, ontologyURI));
    label_2:
    while (true) {
      if (jj_2_2(2)) {
        ;
      } else {
        break label_2;
      }
      anno = Annotation();
        ax = dataFactory.getOWLOntologyAnnotationAxiom(ontology, anno);
        addAxiom(ax);
        currentAnnotations.clear();
    }
    label_3:
    while (true) {
      if (jj_2_3(2)) {
        ;
      } else {
        break label_3;
      }
      ax = Axiom();
        addAxiom(ax);
        for(OWLAnnotation axAnno : currentAnnotations) {
            OWLAxiom axAnnoAx = dataFactory.getOWLAxiomAnnotationAxiom(ax, axAnno);
            addAxiom(axAnnoAx);
        }
        currentAnnotations.clear();
        if(ax instanceof OWLImportsDeclaration) {
            man.makeLoadImportRequest((OWLImportsDeclaration) ax);
        }
    }
    jj_consume_token(CLOSEPAR);
  }

  final public void Namespace() throws ParseException {
    String prefix="";
    String ns;
    Token t;
    jj_consume_token(NAMESPACE);
    jj_consume_token(OPENPAR);
    if (jj_2_4(2)) {
      t = jj_consume_token(NCNAME1);
                                        prefix=t.image;
    } else {
      ;
    }
    jj_consume_token(EQUALS);
    t = jj_consume_token(QURI);
                                                                           ns=t.image;
    jj_consume_token(CLOSEPAR);
        prefixMap.put(prefix, ns.substring(1, ns.length() - 1));
  }

  final public URI URI() throws ParseException {
    URI uri;
    if (jj_2_5(2)) {
      uri = QURI();
    } else if (jj_2_6(2)) {
      uri = QName();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return uri;}
    throw new Error("Missing return statement in function");
  }

  final public URI QURI() throws ParseException {
    Token t;
    t = jj_consume_token(QURI);
        try{
            String s = t.image;
            {if (true) return getURI(s);}
        }
        catch(URISyntaxException e)
        {
            {if (true) throw new OWLRuntimeException(e);}
        }
    throw new Error("Missing return statement in function");
  }

  final public URI QName() throws ParseException {
    String prefix = "";
    String name = null;
    Token t;
    if (jj_2_7(2)) {
      t = jj_consume_token(NCNAME1);
                  prefix=t.image;
      jj_consume_token(COLON);
    } else {
      ;
    }
    t = jj_consume_token(NCNAME1);
                                                         name=t.image;
        try {
        if(prefix != null) {
            String base = prefixMap.get(prefix);

                {if (true) return getURI(base + name);}

        }
        else {
            {if (true) return getURI(ontologyURI.toString() + "#" + name);}
        }
        }
            catch(URISyntaxException e) {
                {if (true) throw new OWLRuntimeException(e);}
            }
    throw new Error("Missing return statement in function");
  }

/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Class Descriptions
//
/////////////////////////////////////////////////////////////////////////////////////////////////////
  final public OWLDescription Description() throws ParseException {
    OWLDescription desc;
    if (jj_2_8(2)) {
      desc = ClassURI();
    } else if (jj_2_9(2)) {
      desc = ObjectUnionOf();
    } else if (jj_2_10(2)) {
      desc = ObjectIntersectionOf();
    } else if (jj_2_11(2)) {
      desc = ObjectComplementOf();
    } else if (jj_2_12(2)) {
      desc = ObjectOneOf();
    } else if (jj_2_13(2)) {
      desc = ObjectSomeValuesFrom();
    } else if (jj_2_14(2)) {
      desc = ObjectAllValuesFrom();
    } else if (jj_2_15(2)) {
      desc = ObjectHasValue();
    } else if (jj_2_16(2)) {
      desc = ObjectSelf();
    } else if (jj_2_17(2)) {
      desc = ObjectMinCardinality();
    } else if (jj_2_18(2)) {
      desc = ObjectExactCardinality();
    } else if (jj_2_19(2)) {
      desc = ObjectMaxCardinality();
    } else if (jj_2_20(2)) {
      desc = DataSomeValuesFrom();
    } else if (jj_2_21(2)) {
      desc = DataAllValuesFrom();
    } else if (jj_2_22(2)) {
      desc = DataHasValue();
    } else if (jj_2_23(2)) {
      desc = DataMinCardinality();
    } else if (jj_2_24(2)) {
      desc = DataExactCardinality();
    } else if (jj_2_25(2)) {
      desc = DataMaxCardinality();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return desc;}
    throw new Error("Missing return statement in function");
  }

  final public OWLClass ClassURI() throws ParseException {
    URI uri;
    uri = URI();
        {if (true) return dataFactory.getOWLClass(uri);}
    throw new Error("Missing return statement in function");
  }

  final public Set<OWLDescription> DescriptionSet() throws ParseException {
    Set<OWLDescription> descriptions = new HashSet<OWLDescription>();
    OWLDescription desc;
    desc = Description();
                        descriptions.add(desc);
    desc = Description();
                       descriptions.add(desc);
    label_4:
    while (true) {
      if (jj_2_26(2)) {
        ;
      } else {
        break label_4;
      }
      desc = Description();
                        descriptions.add(desc);
    }
        {if (true) return descriptions;}
    throw new Error("Missing return statement in function");
  }

  final public Set<OWLIndividual> IndividualMinOneSet() throws ParseException {
    Set<OWLIndividual> individuals = new HashSet<OWLIndividual>();
    OWLIndividual ind;
    ind = IndividualURI();
                          individuals.add(ind);
    label_5:
    while (true) {
      if (jj_2_27(2)) {
        ;
      } else {
        break label_5;
      }
      ind = IndividualURI();
                          individuals.add(ind);
    }
        {if (true) return individuals;}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription ObjectUnionOf() throws ParseException {
    Set<OWLDescription> descriptions;
    jj_consume_token(OBJECTUNIONOF);
    jj_consume_token(OPENPAR);
    descriptions = DescriptionSet();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectUnionOf(descriptions);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription ObjectIntersectionOf() throws ParseException {
    Set<OWLDescription> descriptions;
    jj_consume_token(OBJECTINTERSECTIONOF);
    jj_consume_token(OPENPAR);
    descriptions = DescriptionSet();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectIntersectionOf(descriptions);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription ObjectComplementOf() throws ParseException {
    OWLDescription operand;
    jj_consume_token(OBJECTCOMPLEMENTOF);
    jj_consume_token(OPENPAR);
    operand = Description();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectComplementOf(operand);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription ObjectOneOf() throws ParseException {
    Set<OWLIndividual> individuals;
    jj_consume_token(OBJECTONEOF);
    jj_consume_token(OPENPAR);
    individuals = IndividualMinOneSet();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectOneOf(individuals);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription ObjectAllValuesFrom() throws ParseException {
    OWLObjectPropertyExpression prop;
    OWLDescription filler;
    jj_consume_token(OBJECTALLVALUESFROM);
    jj_consume_token(OPENPAR);
    prop = ObjectPropertyExpression();
    filler = Description();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectAllRestriction(prop, filler);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription ObjectSomeValuesFrom() throws ParseException {
    OWLObjectPropertyExpression prop;
    OWLDescription filler;
    jj_consume_token(OBJECTSOMEVALUESFROM);
    jj_consume_token(OPENPAR);
    prop = ObjectPropertyExpression();
    filler = Description();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectSomeRestriction(prop, filler);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription ObjectHasValue() throws ParseException {
    OWLObjectPropertyExpression prop;
    OWLIndividual ind;
    jj_consume_token(OBJECTHASVALUE);
    jj_consume_token(OPENPAR);
    prop = ObjectPropertyExpression();
    ind = IndividualURI();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectValueRestriction(prop, ind);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription ObjectSelf() throws ParseException {
    OWLObjectPropertyExpression prop;
    jj_consume_token(OBJECTEXISTSSELF);
    jj_consume_token(OPENPAR);
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectSelfRestriction(prop);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription ObjectMinCardinality() throws ParseException {
    int cardinality = 0;
    OWLObjectPropertyExpression prop = null;
    OWLDescription filler = null;
    jj_consume_token(OBJECTMINCARDINALITY);
    jj_consume_token(OPENPAR);
    cardinality = Cardinality();
    prop = ObjectPropertyExpression();
    if (jj_2_28(2)) {
      filler = Description();
    } else {
      ;
    }
    jj_consume_token(CLOSEPAR);
        if(filler == null) {
            {if (true) return dataFactory.getOWLObjectMinCardinalityRestriction(prop, cardinality);}
        }
        else {
            {if (true) return dataFactory.getOWLObjectMinCardinalityRestriction(prop, cardinality, filler);}
        }
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription ObjectExactCardinality() throws ParseException {
    int cardinality = 0;
    OWLObjectPropertyExpression prop = null;
    OWLDescription filler = null;
    jj_consume_token(OBJECTEXACTCARDINALITY);
    jj_consume_token(OPENPAR);
    cardinality = Cardinality();
    prop = ObjectPropertyExpression();
    if (jj_2_29(2)) {
      filler = Description();
    } else {
      ;
    }
    jj_consume_token(CLOSEPAR);
        if(filler == null) {
            {if (true) return dataFactory.getOWLObjectExactCardinalityRestriction(prop, cardinality);}
        }
        else {
            {if (true) return dataFactory.getOWLObjectExactCardinalityRestriction(prop, cardinality, filler);}
        }
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription ObjectMaxCardinality() throws ParseException {
    int cardinality = 0;
    OWLObjectPropertyExpression prop = null;
    OWLDescription filler = null;
    jj_consume_token(OBJECTMAXCARDINALITY);
    jj_consume_token(OPENPAR);
    cardinality = Cardinality();
    prop = ObjectPropertyExpression();
    if (jj_2_30(2)) {
      filler = Description();
    } else {
      ;
    }
    jj_consume_token(CLOSEPAR);
        if(filler == null) {
            {if (true) return dataFactory.getOWLObjectMaxCardinalityRestriction(prop, cardinality);}
        }
        else {
            {if (true) return dataFactory.getOWLObjectMaxCardinalityRestriction(prop, cardinality, filler);}
        }
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription DataAllValuesFrom() throws ParseException {
    OWLDataPropertyExpression prop = null;
    OWLDataRange dataRange = null;
    jj_consume_token(DATAALLVALUESFROM);
    jj_consume_token(OPENPAR);
    prop = DataPropertyExpression();
    dataRange = DataRange();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLDataAllRestriction(prop, dataRange);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription DataSomeValuesFrom() throws ParseException {
    OWLDataPropertyExpression prop = null;
    OWLDataRange dataRange = null;
    jj_consume_token(DATASOMEVALUESFROM);
    jj_consume_token(OPENPAR);
    prop = DataPropertyExpression();
    dataRange = DataRange();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLDataSomeRestriction(prop, dataRange);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription DataHasValue() throws ParseException {
    OWLDataPropertyExpression prop = null;
    OWLTypedConstant typedConstant = null;
    jj_consume_token(DATAHASVALUE);
    jj_consume_token(OPENPAR);
    prop = DataPropertyExpression();
    typedConstant = TypedConstant();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLDataValueRestriction(prop, typedConstant);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription DataMinCardinality() throws ParseException {
    int cardinality = 0;
    OWLDataPropertyExpression prop = null;
    OWLDataRange rng = null;
    jj_consume_token(DATAMINCARDINALITY);
    jj_consume_token(OPENPAR);
    cardinality = Cardinality();
    prop = DataPropertyExpression();
    if (jj_2_31(2)) {
      rng = DataRange();
    } else {
      ;
    }
    jj_consume_token(CLOSEPAR);
        if(rng == null) {
            {if (true) return dataFactory.getOWLDataMinCardinalityRestriction(prop, cardinality);}
        }
        else {
            {if (true) return dataFactory.getOWLDataMinCardinalityRestriction(prop, cardinality, rng);}
        }
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription DataExactCardinality() throws ParseException {
    int cardinality = 0;
    OWLDataPropertyExpression prop = null;
    OWLDataRange rng = null;
    jj_consume_token(DATAEXACTCARDINALITY);
    jj_consume_token(OPENPAR);
    cardinality = Cardinality();
    prop = DataPropertyExpression();
    if (jj_2_32(2)) {
      rng = DataRange();
    } else {
      ;
    }
    jj_consume_token(CLOSEPAR);
        if(rng == null) {
            {if (true) return dataFactory.getOWLDataExactCardinalityRestriction(prop, cardinality);}
        }
        else {
            {if (true) return dataFactory.getOWLDataExactCardinalityRestriction(prop, cardinality, rng);}
        }
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription DataMaxCardinality() throws ParseException {
    int cardinality = 0;
    OWLDataPropertyExpression prop = null;
    OWLDataRange rng = null;
    jj_consume_token(DATAMAXCARDINALITY);
    jj_consume_token(OPENPAR);
    cardinality = Cardinality();
    prop = DataPropertyExpression();
    if (jj_2_33(2)) {
      rng = DataRange();
    } else {
      ;
    }
    jj_consume_token(CLOSEPAR);
         if(rng == null) {
            {if (true) return dataFactory.getOWLDataMaxCardinalityRestriction(prop, cardinality);}
        }
        else {
            {if (true) return dataFactory.getOWLDataMaxCardinalityRestriction(prop, cardinality, rng);}
        }
    throw new Error("Missing return statement in function");
  }

  final public OWLClass Class() throws ParseException {
    OWLClass cls;
    jj_consume_token(CLASS);
    jj_consume_token(OPENPAR);
    cls = ClassURI();
    jj_consume_token(CLOSEPAR);
        {if (true) return cls;}
    throw new Error("Missing return statement in function");
  }

  final public OWLObjectPropertyExpression ObjectPropertyExpression() throws ParseException {
    OWLObjectPropertyExpression prop;
    if (jj_2_34(2)) {
      prop = InverseObjectProperty();
                                 {if (true) return prop;}
    } else if (jj_2_35(2)) {
      prop = ObjectPropertyURI();
                                                                          {if (true) return prop;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public OWLObjectPropertyExpression InverseObjectProperty() throws ParseException {
    OWLObjectPropertyExpression prop;
    jj_consume_token(INVERSEOBJECTPROPERTY);
    jj_consume_token(OPENPAR);
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return prop;}
    throw new Error("Missing return statement in function");
  }

  final public OWLObjectProperty ObjectProperty() throws ParseException {
    OWLObjectProperty prop;
    jj_consume_token(OBJECTPROP);
    jj_consume_token(OPENPAR);
    prop = ObjectPropertyURI();
    jj_consume_token(CLOSEPAR);
        {if (true) return prop;}
    throw new Error("Missing return statement in function");
  }

  final public OWLDataPropertyExpression DataPropertyExpression() throws ParseException {
    OWLDataPropertyExpression prop;
    prop = DataPropertyURI();
        {if (true) return prop;}
    throw new Error("Missing return statement in function");
  }

  final public OWLDataProperty DataPropertyURI() throws ParseException {
    URI uri;
    uri = URI();
        {if (true) return dataFactory.getOWLDataProperty(uri);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDataProperty DataProperty() throws ParseException {
    OWLDataProperty prop;
    jj_consume_token(DATAPROP);
    jj_consume_token(OPENPAR);
    prop = DataPropertyURI();
    jj_consume_token(CLOSEPAR);
        {if (true) return prop;}
    throw new Error("Missing return statement in function");
  }

  final public OWLIndividual Individual() throws ParseException {
    OWLIndividual ind;
    jj_consume_token(INDIVIDUAL);
    jj_consume_token(OPENPAR);
    ind = IndividualURI();
    jj_consume_token(CLOSEPAR);
        {if (true) return ind;}
    throw new Error("Missing return statement in function");
  }

  final public OWLDataType DataType() throws ParseException {
    OWLDataType dt;
    jj_consume_token(DATATYPE);
    jj_consume_token(OPENPAR);
    dt = DataTypeURI();
    jj_consume_token(CLOSEPAR);
        {if (true) return dt;}
    throw new Error("Missing return statement in function");
  }

  final public OWLDataType DataTypeURI() throws ParseException {
    URI uri;
    uri = URI();
        {if (true) return dataFactory.getOWLDataType(uri);}
    throw new Error("Missing return statement in function");
  }

  final public int Cardinality() throws ParseException {
    int card = 0;
    card = Integer();
        {if (true) return card;}
    throw new Error("Missing return statement in function");
  }

  final public int Integer() throws ParseException {
    Token t;
    t = jj_consume_token(INT);
        int i = Integer.parseInt(t.image);
        {if (true) return i;}
    throw new Error("Missing return statement in function");
  }

  final public OWLDataRange DataRange() throws ParseException {
    OWLDataRange rng;
    if (jj_2_36(2)) {
      rng = DataTypeURI();
    } else if (jj_2_37(2)) {
      rng = DataOneOf();
    } else if (jj_2_38(2)) {
      rng = DataComplementOf();
    } else if (jj_2_39(2)) {
      rng = DataRangeRestriction();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return rng;}
    throw new Error("Missing return statement in function");
  }

  final public OWLDataRange DataComplementOf() throws ParseException {
    OWLDataRange rng;
    jj_consume_token(DATACOMPLEMENTOF);
    jj_consume_token(OPENPAR);
    rng = DataRange();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLDataComplementOf(rng);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDataRange DataOneOf() throws ParseException {
    Set<OWLTypedConstant> values = new HashSet<OWLTypedConstant>();
    OWLTypedConstant con = null;
    OWLDataRange rng = null;
    jj_consume_token(DATAONEOF);
    jj_consume_token(OPENPAR);
    con = TypedConstant();
                                             values.add(con);
    label_6:
    while (true) {
      if (jj_2_40(2)) {
        ;
      } else {
        break label_6;
      }
      con = TypedConstant();
                                                                                    values.add(con);
    }
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLDataOneOf(values);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDataRange DataRangeRestriction() throws ParseException {
    OWLRestrictedDataRangeFacetVocabulary v;
    OWLDataRange rng;
    OWLDataRangeFacetRestriction facetRestriction;
    Set<OWLDataRangeFacetRestriction> facetRestrictions = new HashSet<OWLDataRangeFacetRestriction>();
    jj_consume_token(DATATYPERESTRICTION);
    jj_consume_token(OPENPAR);
    rng = DataRange();
    label_7:
    while (true) {
      facetRestriction = DataRangeFacetRestriction();
        facetRestrictions.add(facetRestriction);
      if (jj_2_41(2)) {
        ;
      } else {
        break label_7;
      }
    }
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLDataRangeRestriction(rng, facetRestrictions);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDataRangeFacetRestriction DataRangeFacetRestriction() throws ParseException {
    Token facet;
    OWLTypedConstant con;
    if (jj_2_42(2)) {
      facet = jj_consume_token(LENGTH);
    } else if (jj_2_43(2)) {
      facet = jj_consume_token(MINLENGTH);
    } else if (jj_2_44(2)) {
      facet = jj_consume_token(MAXLENGTH);
    } else if (jj_2_45(2)) {
      facet = jj_consume_token(MININCLUSIVE);
    } else if (jj_2_46(2)) {
      facet = jj_consume_token(MAXINCLUSIVE);
    } else if (jj_2_47(2)) {
      facet = jj_consume_token(MINEXCLUSIVE);
    } else if (jj_2_48(2)) {
      facet = jj_consume_token(MAXEXCLUSIVE);
    } else if (jj_2_49(2)) {
      facet = jj_consume_token(PATTERN);
    } else if (jj_2_50(2)) {
      facet = jj_consume_token(TOTALDIGITS);
    } else if (jj_2_51(2)) {
      facet = jj_consume_token(FRACTIONDIGITS);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    con = TypedConstant();
        OWLRestrictedDataRangeFacetVocabulary v = OWLRestrictedDataRangeFacetVocabulary.getFacetByShortName(facet.image);
        {if (true) return dataFactory.getOWLDataRangeFacetRestriction(v, con);}
    throw new Error("Missing return statement in function");
  }

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Axioms
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public OWLAxiom Axiom() throws ParseException {
    OWLAxiom ax = null;
    if (jj_2_52(2)) {
      ax = ImportsDeclaration();
    } else if (jj_2_53(2)) {
      ax = ClassAxiom();
    } else if (jj_2_54(2)) {
      ax = ObjectPropertyAxiom();
    } else if (jj_2_55(2)) {
      ax = DataPropertyAxiom();
    } else if (jj_2_56(2)) {
      ax = IndividualAxiom();
    } else if (jj_2_57(2)) {
      ax = Declaration();
    } else if (jj_2_58(2)) {
      ax = EntityAnnotation();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return ax;}
    throw new Error("Missing return statement in function");
  }

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Class Axioms
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public OWLClassAxiom ClassAxiom() throws ParseException {
    OWLClassAxiom ax;
    if (jj_2_59(2)) {
      ax = SubClassOf();
    } else if (jj_2_60(2)) {
      ax = EquivalentClasses();
    } else if (jj_2_61(2)) {
      ax = DisjointClasses();
    } else if (jj_2_62(2)) {
      ax = DisjointUnion();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return ax;}
    throw new Error("Missing return statement in function");
  }

  final public OWLClassAxiom SubClassOf() throws ParseException {
    OWLDescription subClass;
    OWLDescription superClass;
    jj_consume_token(SUBCLASSOF);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    subClass = Description();
    superClass = Description();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLSubClassAxiom(subClass, superClass);}
    throw new Error("Missing return statement in function");
  }

  final public OWLClassAxiom EquivalentClasses() throws ParseException {
    Set<OWLDescription> descriptions;
    jj_consume_token(EQUIVALENTCLASSES);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    descriptions = DescriptionSet();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLEquivalentClassesAxiom(descriptions);}
    throw new Error("Missing return statement in function");
  }

  final public OWLClassAxiom DisjointClasses() throws ParseException {
    Set<OWLDescription> descriptions;
    jj_consume_token(DISJOINTCLASSES);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    descriptions = DescriptionSet();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLDisjointClassesAxiom(descriptions);}
    throw new Error("Missing return statement in function");
  }

  final public OWLClassAxiom DisjointUnion() throws ParseException {
    OWLClass cls;
    Set<OWLDescription> descriptions;
    jj_consume_token(DISJOINTUNION);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    cls = ClassURI();
    descriptions = DescriptionSet();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLDisjointUnionAxiom(cls, descriptions);}
    throw new Error("Missing return statement in function");
  }

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Object Property Axioms
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public OWLPropertyAxiom ObjectPropertyAxiom() throws ParseException {
    OWLPropertyAxiom ax;
    if (jj_2_63(2)) {
      ax = SubObjectPropertyOf();
    } else if (jj_2_64(2)) {
      ax = EquivalentObjectProperties();
    } else if (jj_2_65(2)) {
      ax = DisjointObjectProperties();
    } else if (jj_2_66(2)) {
      ax = ObjectPropertyRange();
    } else if (jj_2_67(2)) {
      ax = ObjectPropertyDomain();
    } else if (jj_2_68(2)) {
      ax = FunctionalObjectProperty();
    } else if (jj_2_69(2)) {
      ax = InverseFunctionalObjectProperty();
    } else if (jj_2_70(2)) {
      ax = SymmetricObjectProperty();
    } else if (jj_2_71(2)) {
      ax = AntiSymmetricObjectProperty();
    } else if (jj_2_72(2)) {
      ax = ReflexiveObjectProperty();
    } else if (jj_2_73(2)) {
      ax = IrreflexiveObjectProperty();
    } else if (jj_2_74(2)) {
      ax = TransitiveObjectProperty();
    } else if (jj_2_75(2)) {
      ax = InverseObjectProperties();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return ax;}
    throw new Error("Missing return statement in function");
  }

  final public List<OWLObjectPropertyExpression> SubObjectPropertyChain() throws ParseException {
    OWLObjectPropertyExpression prop;
    List<OWLObjectPropertyExpression> props = new ArrayList<OWLObjectPropertyExpression>();
    jj_consume_token(SUBOBJECTPROPERTYCHAIN);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
                                                                                           props.add(prop);
    label_8:
    while (true) {
      if (jj_2_76(2)) {
        ;
      } else {
        break label_8;
      }
      prop = ObjectPropertyExpression();
                                                                                                                                              props.add(prop);
    }
    jj_consume_token(CLOSEPAR);
        {if (true) return props;}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom SubObjectPropertyOf() throws ParseException {
    OWLObjectPropertyExpression subProperty = null;
    List<OWLObjectPropertyExpression> chain = null;
    OWLObjectPropertyExpression superProperty = null;
    jj_consume_token(SUBOBJECTPROPERTYOF);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    if (jj_2_77(2)) {
      subProperty = ObjectPropertyExpression();
    } else if (jj_2_78(2)) {
      chain = SubObjectPropertyChain();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    superProperty = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
        if(subProperty != null) {
            {if (true) return dataFactory.getOWLSubObjectPropertyAxiom(subProperty, superProperty);}
        }
        else if(chain != null) {
            {if (true) return dataFactory.getOWLObjectPropertyChainSubPropertyAxiom(chain, superProperty);}
        }
        else {
            {if (true) return null;}
        }
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom EquivalentObjectProperties() throws ParseException {
    Set<OWLObjectPropertyExpression> props;
    jj_consume_token(EQUIVALENTOBJECTPROPERTIES);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    props = ObjectPropertySet();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLEquivalentObjectPropertiesAxiom(props);}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom DisjointObjectProperties() throws ParseException {
    Set<OWLObjectPropertyExpression> props;
    jj_consume_token(DISJOINTOBJECTPROPERTIES);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    props = ObjectPropertySet();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLDisjointObjectPropertiesAxiom(props);}
    throw new Error("Missing return statement in function");
  }

  final public Set<OWLObjectPropertyExpression> ObjectPropertySet() throws ParseException {
    OWLObjectPropertyExpression prop;
    Set<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
    prop = ObjectPropertyExpression();
                                     props.add(prop);
    prop = ObjectPropertyExpression();
                                                                                       props.add(prop);
    label_9:
    while (true) {
      if (jj_2_79(2)) {
        ;
      } else {
        break label_9;
      }
      prop = ObjectPropertyExpression();
                                                                                                                                          props.add(prop);
    }
        {if (true) return props;}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom ObjectPropertyRange() throws ParseException {
    OWLObjectPropertyExpression prop;
    OWLDescription range;
    jj_consume_token(OBJECTPROPERTYRANGE);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    range = Description();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectPropertyRangeAxiom(prop, range);}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom ObjectPropertyDomain() throws ParseException {
    OWLObjectPropertyExpression prop;
    OWLDescription desc;
    jj_consume_token(OBJECTPROPERTYDOMAIN);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    desc = Description();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectPropertyDomainAxiom(prop, desc);}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom FunctionalObjectProperty() throws ParseException {
    OWLObjectPropertyExpression prop;
    jj_consume_token(FUNCTIONALOBJECTPROPERTY);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLFunctionalObjectPropertyAxiom(prop);}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom InverseObjectProperties() throws ParseException {
    OWLObjectPropertyExpression propA;
    OWLObjectPropertyExpression propB;
    jj_consume_token(INVERSEOBJECTPROPERTIES);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    propA = ObjectPropertyExpression();
    propB = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLInverseObjectPropertiesAxiom(propA, propB);}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom InverseFunctionalObjectProperty() throws ParseException {
    OWLObjectPropertyExpression prop;
    jj_consume_token(INVERSEFUNCTIONALOBJECTPROPERTY);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop);}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom SymmetricObjectProperty() throws ParseException {
    OWLObjectPropertyExpression prop;
    jj_consume_token(SYMMETRICOBJECTPROPERTY);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLSymmetricObjectPropertyAxiom(prop);}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom AntiSymmetricObjectProperty() throws ParseException {
    OWLObjectPropertyExpression prop;
    jj_consume_token(ANTISYMMETRICOBJECTPROPERTY);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLAntiSymmetricObjectPropertyAxiom(prop);}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom ReflexiveObjectProperty() throws ParseException {
    OWLObjectPropertyExpression prop;
    jj_consume_token(REFLEXIVEOBJECTPROPERTY);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLReflexiveObjectPropertyAxiom(prop);}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom IrreflexiveObjectProperty() throws ParseException {
    OWLObjectPropertyExpression prop;
    jj_consume_token(IRREFLEXIVEOBJECTPROPERTY);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop);}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom TransitiveObjectProperty() throws ParseException {
    OWLObjectPropertyExpression prop;
    jj_consume_token(TRANSITIVEOBJECTPROPERTY);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLTransitiveObjectPropertyAxiom(prop);}
    throw new Error("Missing return statement in function");
  }

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Data Property Axioms
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public OWLPropertyAxiom DataPropertyAxiom() throws ParseException {
    OWLPropertyAxiom ax;
    if (jj_2_80(2)) {
      ax = SubDataPropertyOf();
    } else if (jj_2_81(2)) {
      ax = EquivalentDataProperties();
    } else if (jj_2_82(2)) {
      ax = DisjointDataProperties();
    } else if (jj_2_83(2)) {
      ax = DataPropertyRange();
    } else if (jj_2_84(2)) {
      ax = DataPropertyDomain();
    } else if (jj_2_85(2)) {
      ax = FunctionalDataProperty();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return ax;}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom SubDataPropertyOf() throws ParseException {
    OWLDataPropertyExpression subProperty;
    OWLDataPropertyExpression superProperty;
    jj_consume_token(SUBDATAPROPERTYOF);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    subProperty = DataPropertyExpression();
    superProperty = DataPropertyExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLSubDataPropertyAxiom(subProperty, superProperty);}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom EquivalentDataProperties() throws ParseException {
    Set<OWLDataPropertyExpression> props;
    jj_consume_token(EQUIVALENTDATAPROPERTIES);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    props = DataPropertySet();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLEquivalentDataPropertiesAxiom(props);}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom DisjointDataProperties() throws ParseException {
    Set<OWLDataPropertyExpression> props;
    jj_consume_token(DISJOINTDATAPROPERTIES);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    props = DataPropertySet();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLDisjointDataPropertiesAxiom(props);}
    throw new Error("Missing return statement in function");
  }

  final public Set<OWLDataPropertyExpression> DataPropertySet() throws ParseException {
    OWLDataPropertyExpression prop;
    Set<OWLDataPropertyExpression> props = new HashSet<OWLDataPropertyExpression>();
    prop = DataPropertyExpression();
                                   props.add(prop);
    prop = DataPropertyExpression();
                                                                                   props.add(prop);
    label_10:
    while (true) {
      if (jj_2_86(2)) {
        ;
      } else {
        break label_10;
      }
      prop = DataPropertyExpression();
                                                                                                                                    props.add(prop);
    }
        {if (true) return props;}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom DataPropertyDomain() throws ParseException {
    OWLDataPropertyExpression prop;
    OWLDescription domain;
    jj_consume_token(DATAPROPERTYDOMAIN);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = DataPropertyExpression();
    domain = Description();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLDataPropertyDomainAxiom(prop, domain);}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom DataPropertyRange() throws ParseException {
    OWLDataPropertyExpression prop;
    OWLDataRange rng;
    jj_consume_token(DATAPROPERTYRANGE);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = DataPropertyExpression();
    rng = DataRange();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLDataPropertyRangeAxiom(prop, rng);}
    throw new Error("Missing return statement in function");
  }

  final public OWLPropertyAxiom FunctionalDataProperty() throws ParseException {
    OWLDataPropertyExpression prop;
    jj_consume_token(FUNCTIONALDATAPROPERTY);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = DataPropertyExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLFunctionalDataPropertyAxiom(prop);}
    throw new Error("Missing return statement in function");
  }

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Individual Axioms
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public OWLIndividualAxiom IndividualAxiom() throws ParseException {
    OWLIndividualAxiom ax;
    if (jj_2_87(2)) {
      ax = SameIndividuals();
    } else if (jj_2_88(2)) {
      ax = DifferentIndividuals();
    } else if (jj_2_89(2)) {
      ax = ClassAssertion();
    } else if (jj_2_90(2)) {
      ax = ObjectPropertyAssertion();
    } else if (jj_2_91(2)) {
      ax = DataPropertyAssertion();
    } else if (jj_2_92(2)) {
      ax = NegativeObjectPropertyAssertion();
    } else if (jj_2_93(2)) {
      ax = NegativeDataPropertyAssertion();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return ax;}
    throw new Error("Missing return statement in function");
  }

  final public Set<OWLIndividual> IndividualSet() throws ParseException {
    OWLIndividual ind;
    Set<OWLIndividual> individuals = new HashSet<OWLIndividual>();
    ind = IndividualURI();
                         individuals.add(ind);
    ind = IndividualURI();
                                                                    individuals.add(ind);
    label_11:
    while (true) {
      if (jj_2_94(2)) {
        ;
      } else {
        break label_11;
      }
      ind = IndividualURI();
                                                                                                                individuals.add(ind);
    }
        {if (true) return individuals;}
    throw new Error("Missing return statement in function");
  }

  final public OWLIndividualAxiom SameIndividuals() throws ParseException {
    Set<OWLIndividual> individuals;
    jj_consume_token(SAMEINDIVIDUALS);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    individuals = IndividualSet();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLSameIndividualsAxiom(individuals);}
    throw new Error("Missing return statement in function");
  }

  final public OWLIndividualAxiom DifferentIndividuals() throws ParseException {
    Set<OWLIndividual> individuals;
    jj_consume_token(DIFFERENTINDIVIDUALS);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    individuals = IndividualSet();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLDifferentIndividualsAxiom(individuals);}
    throw new Error("Missing return statement in function");
  }

  final public OWLIndividualAxiom ClassAssertion() throws ParseException {
    OWLIndividual ind;
    OWLDescription desc;
    jj_consume_token(CLASSASSERTION);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    ind = IndividualURI();
    desc = Description();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLClassAssertionAxiom(ind, desc);}
    throw new Error("Missing return statement in function");
  }

  final public OWLIndividualAxiom ObjectPropertyAssertion() throws ParseException {
    OWLIndividual subj;
    OWLObjectPropertyExpression prop;
    OWLIndividual obj;
    jj_consume_token(OBJECTPROPERTYASSERTION);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    subj = IndividualURI();
    obj = IndividualURI();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectPropertyAssertionAxiom(subj, prop, obj);}
    throw new Error("Missing return statement in function");
  }

  final public OWLIndividualAxiom NegativeObjectPropertyAssertion() throws ParseException {
    OWLIndividual subj;
    OWLObjectPropertyExpression prop;
    OWLIndividual obj;
    jj_consume_token(NEGATIVEOBJECTPROPERTYASSERTION);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    subj = IndividualURI();
    obj = IndividualURI();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLNegativeObjectPropertyAssertionAxiom(subj, prop, obj);}
    throw new Error("Missing return statement in function");
  }

  final public OWLIndividualAxiom DataPropertyAssertion() throws ParseException {
    OWLIndividual subj;
    OWLDataPropertyExpression prop;
    OWLConstant obj;
    jj_consume_token(DATAPROPERTYASSERTION);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = DataPropertyExpression();
    subj = IndividualURI();
    obj = Constant();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLDataPropertyAssertionAxiom(subj, prop, obj);}
    throw new Error("Missing return statement in function");
  }

  final public OWLIndividualAxiom NegativeDataPropertyAssertion() throws ParseException {
    OWLIndividual subj;
    OWLDataPropertyExpression prop;
    OWLConstant obj;
    jj_consume_token(NEGATIVEDATAPROPERTYASSERTION);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    prop = DataPropertyExpression();
    subj = IndividualURI();
    obj = Constant();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLNegativeDataPropertyAssertionAxiom(subj, prop, obj);}
    throw new Error("Missing return statement in function");
  }

  final public OWLIndividual IndividualURI() throws ParseException {
    URI uri;
    uri = URI();
               {if (true) return dataFactory.getOWLIndividual(uri);}
    throw new Error("Missing return statement in function");
  }

  final public OWLObjectProperty ObjectPropertyURI() throws ParseException {
    URI uri;
    uri = URI();
              {if (true) return dataFactory.getOWLObjectProperty(uri);}
    throw new Error("Missing return statement in function");
  }

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Annotation Stuff
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public OWLAnnotation Annotation() throws ParseException {
    URI uri;
    OWLConstant con;
    if (jj_2_95(2)) {
      jj_consume_token(LABEL);
      jj_consume_token(OPENPAR);
      con = Constant();
      jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLConstantAnnotation(OWLRDFVocabulary.RDFS_LABEL.getURI(), con);}
    } else if (jj_2_96(2)) {
      jj_consume_token(COMMENT);
      jj_consume_token(OPENPAR);
      con = Constant();
      jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLConstantAnnotation(OWLRDFVocabulary.RDFS_COMMENT.getURI(), con);}
    } else if (jj_2_97(2)) {
      jj_consume_token(ANNOTATION);
      jj_consume_token(OPENPAR);
      uri = URI();
      con = Constant();
      jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLConstantAnnotation(uri, con);}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void AxiomAnnotationSet() throws ParseException {
    OWLAnnotation anno;
    label_12:
    while (true) {
      if (jj_2_98(2)) {
        ;
      } else {
        break label_12;
      }
      anno = Annotation();
        currentAnnotations.add(anno);
    }
  }

  final public OWLImportsDeclaration ImportsDeclaration() throws ParseException {
    URI uri;
    jj_consume_token(IMPORTS);
    jj_consume_token(OPENPAR);
    uri = URI();
    jj_consume_token(CLOSEPAR);
        OWLImportsDeclaration importsDeclaration = dataFactory.getOWLImportsDeclarationAxiom(ontology, uri);
        {if (true) return importsDeclaration;}
    throw new Error("Missing return statement in function");
  }

  final public void DocumentationAnnotation() throws ParseException {
    jj_consume_token(DOCUMENTATION);
    jj_consume_token(OPENPAR);
    TypedConstant();
    jj_consume_token(CLOSEPAR);
  }

  final public OWLEntityAnnotationAxiom EntityAnnotation() throws ParseException {
    OWLEntity entity;
    OWLAnnotation anno;
    jj_consume_token(ENTITYANNOTATION);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    entity = Entity();
    anno = Annotation();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLEntityAnnotationAxiom(entity, anno);}
    throw new Error("Missing return statement in function");
  }

  final public OWLAxiom Declaration() throws ParseException {
    OWLEntity entity = null;
    URI uri = null;
    OWLConstant con = null;
    jj_consume_token(DECLARATION);
    jj_consume_token(OPENPAR);
    AxiomAnnotationSet();
    entity = Entity();
    jj_consume_token(CLOSEPAR);
        if(ignoreAnnotationsAndDeclarations) {
            {if (true) return null;}
        }
        else {
            {if (true) return dataFactory.getOWLDeclarationAxiom(entity);}
        }
    throw new Error("Missing return statement in function");
  }

  final public OWLEntity Entity() throws ParseException {
    OWLEntity entity;
    if (jj_2_99(2)) {
      entity = Class();
    } else if (jj_2_100(2)) {
      entity = ObjectProperty();
    } else if (jj_2_101(2)) {
      entity = DataProperty();
    } else if (jj_2_102(2)) {
      entity = Individual();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return entity;}
    throw new Error("Missing return statement in function");
  }

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Data Stuff
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public OWLConstant Constant() throws ParseException {
    OWLConstant con;
    if (jj_2_103(2)) {
      con = TypedConstant();
    } else if (jj_2_104(2)) {
      con = UntypedConstant();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return con;}
    throw new Error("Missing return statement in function");
  }

  final public OWLTypedConstant TypedConstant() throws ParseException {
    String literal;
    OWLDataType dataType=null;
    literal = StringLiteral();
    jj_consume_token(100);
    dataType = DataTypeURI();
            {if (true) return dataFactory.getOWLTypedConstant(literal, dataType);}
    throw new Error("Missing return statement in function");
  }

  final public OWLUntypedConstant UntypedConstant() throws ParseException {
    String literal;
    String lang = null;
    literal = StringLiteral();
    if (jj_2_105(2)) {
      lang = LangTag();
    } else {
      ;
    }
            if(lang == null) {
                {if (true) return dataFactory.getOWLUntypedConstant(literal);}
            }
            else {
                {if (true) return dataFactory.getOWLUntypedConstant(literal, lang);}
            }
    throw new Error("Missing return statement in function");
  }

  final public String StringLiteral() throws ParseException {
    Token t;
    t = jj_consume_token(STRINGLITERAL);
        String raw = t.image.substring(1, t.image.length() - 1);
        {if (true) return EscapeUtils.unescapeString(raw);}
    throw new Error("Missing return statement in function");
  }

  final public String LangTag() throws ParseException {
    String lang = "";
        Token t;
    jj_consume_token(LANGIDENTIFIER);
    t = jj_consume_token(NCNAME1);
                                   lang += t.image;
        {if (true) return lang;}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  final private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  final private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  final private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  final private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  final private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  final private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  final private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  final private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  final private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  final private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  final private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  final private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_64(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  final private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_65(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  final private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_66(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  final private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_67(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  final private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_68(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  final private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_69(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  final private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_70(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  final private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_71(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  final private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_72(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  final private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_73(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  final private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_74(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  final private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_75(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  final private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_76(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  final private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_77(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  final private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_78(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  final private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_79(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  final private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_80(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  final private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_81(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  final private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_82(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  final private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_83(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  final private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_84(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  final private boolean jj_2_85(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_85(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  final private boolean jj_2_86(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_86(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  final private boolean jj_2_87(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_87(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  final private boolean jj_2_88(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_88(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  final private boolean jj_2_89(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_89(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  final private boolean jj_2_90(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_90(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  final private boolean jj_2_91(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_91(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  final private boolean jj_2_92(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_92(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  final private boolean jj_2_93(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_93(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  final private boolean jj_2_94(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_94(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  final private boolean jj_2_95(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_95(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  final private boolean jj_2_96(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_96(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  final private boolean jj_2_97(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_97(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  final private boolean jj_2_98(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_98(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  final private boolean jj_2_99(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_99(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  final private boolean jj_2_100(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_100(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  final private boolean jj_2_101(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_101(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  final private boolean jj_2_102(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_102(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  final private boolean jj_2_103(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_103(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  final private boolean jj_2_104(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_104(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  final private boolean jj_2_105(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_105(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(104, xla); }
  }

  final private boolean jj_3R_41() {
    if (jj_3R_93()) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_scan_token(NCNAME1)) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  final private boolean jj_3R_17() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) jj_scanpos = xsp;
    if (jj_scan_token(NCNAME1)) return true;
    return false;
  }

  final private boolean jj_3_80() {
    if (jj_3R_73()) return true;
    return false;
  }

  final private boolean jj_3_83() {
    if (jj_3R_76()) return true;
    return false;
  }

  final private boolean jj_3R_50() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_80()) {
    jj_scanpos = xsp;
    if (jj_3_81()) {
    jj_scanpos = xsp;
    if (jj_3_82()) {
    jj_scanpos = xsp;
    if (jj_3_83()) {
    jj_scanpos = xsp;
    if (jj_3_84()) {
    jj_scanpos = xsp;
    if (jj_3_85()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3_33() {
    if (jj_3R_38()) return true;
    return false;
  }

  final private boolean jj_3R_92() {
    if (jj_scan_token(LANGIDENTIFIER)) return true;
    if (jj_scan_token(NCNAME1)) return true;
    return false;
  }

  final private boolean jj_3R_90() {
    if (jj_scan_token(INDIVIDUAL)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_scan_token(TRANSITIVEOBJECTPROPERTY)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_105() {
    if (jj_3R_92()) return true;
    return false;
  }

  final private boolean jj_3_79() {
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3R_16() {
    if (jj_scan_token(QURI)) return true;
    return false;
  }

  final private boolean jj_3_102() {
    if (jj_3R_90()) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_scan_token(NCNAME1)) return true;
    return false;
  }

  final private boolean jj_3R_89() {
    if (jj_scan_token(DATAPROP)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_scan_token(IRREFLEXIVEOBJECTPROPERTY)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3R_94() {
    if (jj_scan_token(STRINGLITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_93() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3_6()) return true;
    }
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_3R_40()) return true;
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_3R_38()) return true;
    return false;
  }

  final private boolean jj_3R_95() {
    if (jj_3R_93()) return true;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_scan_token(REFLEXIVEOBJECTPROPERTY)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_91() {
    if (jj_3R_94()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_105()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_101() {
    if (jj_3R_89()) return true;
    return false;
  }

  final private boolean jj_3R_13() {
    if (jj_scan_token(NAMESPACE)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_3R_95()) return true;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_scan_token(ANTISYMMETRICOBJECTPROPERTY)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_104() {
    if (jj_3R_91()) return true;
    return false;
  }

  final private boolean jj_3_31() {
    if (jj_3R_38()) return true;
    return false;
  }

  final private boolean jj_3R_88() {
    if (jj_scan_token(OBJECTPROP)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_scan_token(SYMMETRICOBJECTPROPERTY)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_3R_94()) return true;
    if (jj_scan_token(100)) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_scan_token(INVERSEOBJECTPROPERTY)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_76() {
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_scan_token(INVERSEFUNCTIONALOBJECTPROPERTY)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_78() {
    if (jj_3R_72()) return true;
    return false;
  }

  final private boolean jj_3_100() {
    if (jj_3R_88()) return true;
    return false;
  }

  final private boolean jj_3_103() {
    if (jj_3R_45()) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_14()) return true;
    return false;
  }

  final private boolean jj_3R_71() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3_35()) return true;
    }
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_3R_39()) return true;
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_scan_token(INVERSEOBJECTPROPERTIES)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_87() {
    if (jj_scan_token(CLASS)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_13()) return true;
    return false;
  }

  final private boolean jj_3_75() {
    if (jj_3R_70()) return true;
    return false;
  }

  final private boolean jj_3_99() {
    if (jj_3R_87()) return true;
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_scan_token(FUNCTIONALOBJECTPROPERTY)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_30() {
    if (jj_3R_36()) return true;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_scan_token(OBJECTPROPERTYDOMAIN)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(DATAMAXCARDINALITY)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_scan_token(DECLARATION)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_77() {
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_scan_token(OBJECTPROPERTYRANGE)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_29() {
    if (jj_3R_36()) return true;
    return false;
  }

  final private boolean jj_3_71() {
    if (jj_3R_66()) return true;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_scan_token(ENTITYANNOTATION)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_scan_token(DATAEXACTCARDINALITY)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_74() {
    if (jj_3R_69()) return true;
    return false;
  }

  final private boolean jj_3_65() {
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_28() {
    if (jj_3R_36()) return true;
    return false;
  }

  final private boolean jj_3_68() {
    if (jj_3R_63()) return true;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_scan_token(DISJOINTOBJECTPROPERTIES)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_scan_token(DATAMINCARDINALITY)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_scan_token(IMPORTS)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_scan_token(EQUIVALENTOBJECTPROPERTIES)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_70() {
    if (jj_3R_65()) return true;
    return false;
  }

  final private boolean jj_3_98() {
    if (jj_3R_14()) return true;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_scan_token(DATAHASVALUE)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_73() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3_97() {
    if (jj_scan_token(ANNOTATION)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_scan_token(DATASOMEVALUESFROM)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_67() {
    if (jj_3R_62()) return true;
    return false;
  }

  final private boolean jj_3_64() {
    if (jj_3R_59()) return true;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_scan_token(SUBOBJECTPROPERTYOF)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_96() {
    if (jj_scan_token(COMMENT)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_95() {
    if (jj_scan_token(LABEL)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_14() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_95()) {
    jj_scanpos = xsp;
    if (jj_3_96()) {
    jj_scanpos = xsp;
    if (jj_3_97()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_scan_token(DATAALLVALUESFROM)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_scan_token(SUBOBJECTPROPERTYCHAIN)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_62() {
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_3R_93()) return true;
    return false;
  }

  final private boolean jj_3_72() {
    if (jj_3R_67()) return true;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_scan_token(OBJECTMAXCARDINALITY)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_69() {
    if (jj_3R_64()) return true;
    return false;
  }

  final private boolean jj_3_66() {
    if (jj_3R_61()) return true;
    return false;
  }

  final private boolean jj_3_63() {
    if (jj_3R_58()) return true;
    return false;
  }

  final private boolean jj_3R_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_63()) {
    jj_scanpos = xsp;
    if (jj_3_64()) {
    jj_scanpos = xsp;
    if (jj_3_65()) {
    jj_scanpos = xsp;
    if (jj_3_66()) {
    jj_scanpos = xsp;
    if (jj_3_67()) {
    jj_scanpos = xsp;
    if (jj_3_68()) {
    jj_scanpos = xsp;
    if (jj_3_69()) {
    jj_scanpos = xsp;
    if (jj_3_70()) {
    jj_scanpos = xsp;
    if (jj_3_71()) {
    jj_scanpos = xsp;
    if (jj_3_72()) {
    jj_scanpos = xsp;
    if (jj_3_73()) {
    jj_scanpos = xsp;
    if (jj_3_74()) {
    jj_scanpos = xsp;
    if (jj_3_75()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_3R_93()) return true;
    return false;
  }

  final private boolean jj_3_94() {
    if (jj_3R_37()) return true;
    return false;
  }

  final private boolean jj_3R_86() {
    if (jj_scan_token(NEGATIVEDATAPROPERTYASSERTION)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_scan_token(OBJECTEXACTCARDINALITY)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_61() {
    if (jj_3R_56()) return true;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_scan_token(DISJOINTUNION)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_84() {
    if (jj_scan_token(DATAPROPERTYASSERTION)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_scan_token(DISJOINTCLASSES)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_90() {
    if (jj_3R_83()) return true;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_scan_token(OBJECTMINCARDINALITY)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_93() {
    if (jj_3R_86()) return true;
    return false;
  }

  final private boolean jj_3R_85() {
    if (jj_scan_token(NEGATIVEOBJECTPROPERTYASSERTION)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_scan_token(EQUIVALENTCLASSES)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_60() {
    if (jj_3R_55()) return true;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_scan_token(OBJECTEXISTSSELF)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(SUBCLASSOF)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_83() {
    if (jj_scan_token(OBJECTPROPERTYASSERTION)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_89() {
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_scan_token(OBJECTHASVALUE)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_86() {
    if (jj_3R_79()) return true;
    return false;
  }

  final private boolean jj_3_59() {
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3R_48() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_59()) {
    jj_scanpos = xsp;
    if (jj_3_60()) {
    jj_scanpos = xsp;
    if (jj_3_61()) {
    jj_scanpos = xsp;
    if (jj_3_62()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_scan_token(CLASSASSERTION)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_23() {
    if (jj_scan_token(OBJECTSOMEVALUESFROM)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3R_81() {
    if (jj_scan_token(DIFFERENTINDIVIDUALS)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_58() {
    if (jj_3R_53()) return true;
    return false;
  }

  final private boolean jj_3_57() {
    if (jj_3R_52()) return true;
    return false;
  }

  final private boolean jj_3_56() {
    if (jj_3R_51()) return true;
    return false;
  }

  final private boolean jj_3_92() {
    if (jj_3R_85()) return true;
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_scan_token(OBJECTALLVALUESFROM)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_55() {
    if (jj_3R_50()) return true;
    return false;
  }

  final private boolean jj_3_54() {
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3_53() {
    if (jj_3R_48()) return true;
    return false;
  }

  final private boolean jj_3_41() {
    if (jj_3R_46()) return true;
    return false;
  }

  final private boolean jj_3_40() {
    if (jj_3R_45()) return true;
    return false;
  }

  final private boolean jj_3_52() {
    if (jj_3R_47()) return true;
    return false;
  }

  final private boolean jj_3R_15() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_52()) {
    jj_scanpos = xsp;
    if (jj_3_53()) {
    jj_scanpos = xsp;
    if (jj_3_54()) {
    jj_scanpos = xsp;
    if (jj_3_55()) {
    jj_scanpos = xsp;
    if (jj_3_56()) {
    jj_scanpos = xsp;
    if (jj_3_57()) {
    jj_scanpos = xsp;
    if (jj_3_58()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_88() {
    if (jj_3R_81()) return true;
    return false;
  }

  final private boolean jj_3R_80() {
    if (jj_scan_token(SAMEINDIVIDUALS)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_3R_26()) return true;
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_3R_33()) return true;
    return false;
  }

  final private boolean jj_3R_22() {
    if (jj_scan_token(OBJECTONEOF)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_21()) return true;
    return false;
  }

  final private boolean jj_3_39() {
    if (jj_3R_44()) return true;
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_scan_token(OBJECTCOMPLEMENTOF)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_51() {
    if (jj_scan_token(FRACTIONDIGITS)) return true;
    return false;
  }

  final private boolean jj_3_50() {
    if (jj_scan_token(TOTALDIGITS)) return true;
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_3R_29()) return true;
    return false;
  }

  final private boolean jj_3_49() {
    if (jj_scan_token(PATTERN)) return true;
    return false;
  }

  final private boolean jj_3_48() {
    if (jj_scan_token(MAXEXCLUSIVE)) return true;
    return false;
  }

  final private boolean jj_3_87() {
    if (jj_3R_80()) return true;
    return false;
  }

  final private boolean jj_3_91() {
    if (jj_3R_84()) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_87()) {
    jj_scanpos = xsp;
    if (jj_3_88()) {
    jj_scanpos = xsp;
    if (jj_3_89()) {
    jj_scanpos = xsp;
    if (jj_3_90()) {
    jj_scanpos = xsp;
    if (jj_3_91()) {
    jj_scanpos = xsp;
    if (jj_3_92()) {
    jj_scanpos = xsp;
    if (jj_3_93()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_47() {
    if (jj_scan_token(MINEXCLUSIVE)) return true;
    return false;
  }

  final private boolean jj_3_46() {
    if (jj_scan_token(MAXINCLUSIVE)) return true;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_scan_token(OBJECTINTERSECTIONOF)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_45() {
    if (jj_scan_token(MININCLUSIVE)) return true;
    return false;
  }

  final private boolean jj_3_44() {
    if (jj_scan_token(MAXLENGTH)) return true;
    return false;
  }

  final private boolean jj_3_22() {
    if (jj_3R_32()) return true;
    return false;
  }

  final private boolean jj_3_43() {
    if (jj_scan_token(MINLENGTH)) return true;
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_scan_token(LENGTH)) return true;
    return false;
  }

  final private boolean jj_3R_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_42()) {
    jj_scanpos = xsp;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3_44()) {
    jj_scanpos = xsp;
    if (jj_3_45()) {
    jj_scanpos = xsp;
    if (jj_3_46()) {
    jj_scanpos = xsp;
    if (jj_3_47()) {
    jj_scanpos = xsp;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3_49()) {
    jj_scanpos = xsp;
    if (jj_3_50()) {
    jj_scanpos = xsp;
    if (jj_3_51()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    if (jj_3R_45()) return true;
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_scan_token(OBJECTUNIONOF)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_38() {
    if (jj_3R_43()) return true;
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_scan_token(FUNCTIONALDATAPROPERTY)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_20()) return true;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(DATATYPERESTRICTION)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_3R_37()) return true;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_scan_token(DATAPROPERTYRANGE)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_25() {
    if (jj_3R_35()) return true;
    return false;
  }

  final private boolean jj_3_18() {
    if (jj_3R_28()) return true;
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_3R_31()) return true;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_scan_token(DATAONEOF)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_3R_36()) return true;
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_3R_42()) return true;
    return false;
  }

  final private boolean jj_3_82() {
    if (jj_3R_75()) return true;
    return false;
  }

  final private boolean jj_3R_77() {
    if (jj_scan_token(DATAPROPERTYDOMAIN)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_85() {
    if (jj_3R_78()) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_scan_token(DATACOMPLEMENTOF)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_18() {
    if (jj_3R_93()) return true;
    return false;
  }

  final private boolean jj_3_36() {
    if (jj_3R_41()) return true;
    return false;
  }

  final private boolean jj_3R_38() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_36()) {
    jj_scanpos = xsp;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3_38()) {
    jj_scanpos = xsp;
    if (jj_3_39()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_3R_34()) return true;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_3R_30()) return true;
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_3R_27()) return true;
    return false;
  }

  final private boolean jj_3R_75() {
    if (jj_scan_token(DISJOINTDATAPROPERTIES)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_3R_23()) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_18()) return true;
    return false;
  }

  final private boolean jj_3R_36() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3_21()) {
    jj_scanpos = xsp;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3_25()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_81() {
    if (jj_3R_74()) return true;
    return false;
  }

  final private boolean jj_3_84() {
    if (jj_3R_77()) return true;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_scan_token(EQUIVALENTDATAPROPERTIES)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_scan_token(SUBDATAPROPERTYOF)) return true;
    if (jj_scan_token(OPENPAR)) return true;
    return false;
  }

  public OWLFunctionalSyntaxParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[0];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
      jj_la1_3();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {};
   }
   private static void jj_la1_3() {
      jj_la1_3 = new int[] {};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[105];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public OWLFunctionalSyntaxParser(java.io.InputStream stream) {
     this(stream, null);
  }
  public OWLFunctionalSyntaxParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new OWLFunctionalSyntaxParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public OWLFunctionalSyntaxParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new OWLFunctionalSyntaxParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public OWLFunctionalSyntaxParser(OWLFunctionalSyntaxParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(OWLFunctionalSyntaxParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[101];
    for (int i = 0; i < 101; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 0; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 101; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 105; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
            case 80: jj_3_81(); break;
            case 81: jj_3_82(); break;
            case 82: jj_3_83(); break;
            case 83: jj_3_84(); break;
            case 84: jj_3_85(); break;
            case 85: jj_3_86(); break;
            case 86: jj_3_87(); break;
            case 87: jj_3_88(); break;
            case 88: jj_3_89(); break;
            case 89: jj_3_90(); break;
            case 90: jj_3_91(); break;
            case 91: jj_3_92(); break;
            case 92: jj_3_93(); break;
            case 93: jj_3_94(); break;
            case 94: jj_3_95(); break;
            case 95: jj_3_96(); break;
            case 96: jj_3_97(); break;
            case 97: jj_3_98(); break;
            case 98: jj_3_99(); break;
            case 99: jj_3_100(); break;
            case 100: jj_3_101(); break;
            case 101: jj_3_102(); break;
            case 102: jj_3_103(); break;
            case 103: jj_3_104(); break;
            case 104: jj_3_105(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
