package org.coode.owl.rdfxml.parser;

import java.net.URI;

import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.util.OWLDataUtil;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;


/**
 * Author: Evren Sirin<br>
 * Clark &amp; Parsia, LLC<br>
 * Date: 22-04-2008<br><br>
 */
public class FacetRestrictionListItemTranslator implements ListItemTranslator<OWLDataRangeFacetRestriction> {

    private OWLRDFConsumer consumer;


    public FacetRestrictionListItemTranslator(OWLRDFConsumer consumer) {
        this.consumer = consumer;
    }


    public OWLDataRangeFacetRestriction translate(URI uri) throws OWLException {
        for (OWLRestrictedDataRangeFacetVocabulary facet : OWLRestrictedDataRangeFacetVocabulary.values()) {
            OWLConstant val;
            while ((val = consumer.getLiteralObject(uri, facet.getURI(), true)) != null) {
                if (val.isTyped()) {
                    return consumer.getDataFactory().getOWLDataRangeFacetRestriction(
                           facet,
                           (OWLTypedConstant) val);
                }
                else {
                    return consumer.getDataFactory().getOWLDataRangeFacetRestriction(
                           facet,
                           consumer.getDataFactory().getOWLTypedConstant(val.getLiteral(),
                                                            OWLDataUtil.getIntDataType(consumer.getDataFactory())));
                }
            }
        }
        
        return null;
    }


    public OWLDataRangeFacetRestriction translate(OWLConstant firstObject) throws OWLException {
        throw new OWLRDFParserException(
                "Cannot translate list item to facet restriction, because rdf:first triple is a literal triple.");
    }
}
