/**
 * SimMetrics - SimMetrics is a java library of Similarity or Distance
 * Metrics, e.g. Levenshtein Distance, that provide float based similarity
 * measures between String Data. All metrics return consistant measures
 * rather than unbounded similarity scores.
 *
 * Copyright (C) 2005 Sam Chapman - Open Source Release v1.1
 *
 * Please Feel free to contact me about this library, I would appreciate
 * knowing quickly what you wish to use it for and any criticisms/comments
 * upon the SimMetric library.
 *
 * email:       s.chapman@dcs.shef.ac.uk
 * www:         http://www.dcs.shef.ac.uk/~sam/
 * www:         http://www.dcs.shef.ac.uk/~sam/stringmetrics.html
 *
 * address:     Sam Chapman,
 *              Department of Computer Science,
 *              University of Sheffield,
 *              Sheffield,
 *              S. Yorks,
 *              S1 4DP
 *              United Kingdom,
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package simmetrics.api;

import java.util.Set;
import java.util.Vector;


/**
 * Package: api
 * Description: InterfaceTokeniser interface for a Tokeniser class.
 * Date: 31-Mar-2004
 * Time: 15:09:09
 *
 * @author Sam Chapman
 * @version 1.1
 */
public interface InterfaceTokeniser {

    /**
     * displays the tokenisation method.
     *
     * @return short description string
     */
    public String getShortDescriptionString();

    /**
     * displays the delimitors used - (if applicable).
     *
     * @return string for the delimitors used - (if applicable) "" otherwise
     */
    public String getDelimiters();

    /**
     * gets the stop word handler used.
     * @return the stop word handler used
     */
    public InterfaceTermHandler getStopWordHandler();

    /**
     * sets the stop word handler used with the handler given.
     * @param stopWordHandler the given stop word hanlder
     */
    public void setStopWordHandler(InterfaceTermHandler stopWordHandler);

    /**
     * Return tokenized version of a string.
     *
     * @param input
     *
     * @return tokenized version of a string
     */
    public Vector tokenize(String input);

    /**
     * Return tokenized version of a string as a set.
     *
     * @param input
     *
     * @return tokenized version of a string as a set
     */
    public Set tokenizeToSet(String input);
}

