# MySQL-Front 3.2  (Build 14.8)

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES latin1 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='SYSTEM' */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE */;
/*!40101 SET SQL_MODE='STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES */;
/*!40103 SET SQL_NOTES='ON' */;


# Host: 127.0.0.1    Database: xssd_registry
# ------------------------------------------------------
# Server version 5.0.22-community-nt

DROP DATABASE IF EXISTS `xssd_registry`;
CREATE DATABASE `xssd_registry` /*!40100 DEFAULT CHARACTER SET latin1 */;
USE `xssd_registry`;


SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
--  Table structure for `domainontology`
-- ----------------------------
DROP TABLE IF EXISTS `domainontology`;
CREATE TABLE `domainontology` (
  `NameSpace` varchar(256) NOT NULL,
  `Ontology_ID` int(11) NOT NULL auto_increment,
  `Ontology_UUID` varchar(36) NOT NULL,
  `Version_Info` varchar(256) NOT NULL,
  `LastVersion_LocalAddr` varchar(256) default NULL,
  `LastVersion_Time` datetime default NULL,
  `Accessibility` bit(1) NOT NULL,
  `Concept_Num` int(11) NOT NULL,
  `Base` varchar(256) default NULL,
  PRIMARY KEY  (`Ontology_ID`),
  KEY `Ontology_ID` (`Ontology_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `ontologyconcept`
-- ----------------------------
DROP TABLE IF EXISTS `ontologyconcept`;
CREATE TABLE `ontologyconcept` (
  `Ontology_ID` int(11) NOT NULL,
  `Concept_ID` int(11) NOT NULL auto_increment,
  `Concept_UUID` varchar(36) NOT NULL,
  `Concept_URL` varchar(256) NOT NULL,
  `Direct_SubClasses` varchar(10240) default NULL,
  `Direct_SuperClasses` varchar(10240) default NULL,
  `Equivalent` varchar(256) default NULL,
  PRIMARY KEY  (`Concept_ID`),
  KEY `Ontology_ID` (`Ontology_ID`,`Concept_ID`),
  CONSTRAINT `ontologyconcept_ibfk_1` FOREIGN KEY (`Ontology_ID`) REFERENCES `domainontology` (`Ontology_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=REDUNDANT;

-- ----------------------------
--  Table structure for `ontologymapping`
-- ----------------------------
DROP TABLE IF EXISTS `ontologymapping`;
CREATE TABLE `ontologymapping` (
  `DomainOntology_ID` int(11) NOT NULL,
  `ReferencedOntology_ID` int(11) NOT NULL,
  KEY `DomainOntology_ID` (`DomainOntology_ID`,`ReferencedOntology_ID`),
  KEY `FK_OntologyMapping1_DomainOntology1` (`ReferencedOntology_ID`),
  CONSTRAINT `ontologymapping_ibfk_1` FOREIGN KEY (`ReferencedOntology_ID`) REFERENCES `domainontology` (`Ontology_ID`),
  CONSTRAINT `ontologymapping_ibfk_2` FOREIGN KEY (`DomainOntology_ID`) REFERENCES `domainontology` (`Ontology_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `providerinfo`
-- ----------------------------
DROP TABLE IF EXISTS `providerinfo`;
CREATE TABLE `providerinfo` (
  `Provider_ID` int(11) NOT NULL auto_increment,
  `Provider_UUID` varchar(36) NOT NULL,
  `Provider_URL` varchar(256) NOT NULL,
  `Provider_Reputation` float default '0',
  `Provider_ServiceNum` int(11) default '0',
  `Phone` decimal(18,0) default NULL,
  `Email` varchar(50) default NULL,
  `Address` varchar(256) default NULL,
  PRIMARY KEY  (`Provider_ID`),
  KEY `Provider_ID` (`Provider_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `requestfunctioninfo`
-- ----------------------------
DROP TABLE IF EXISTS `requestfunctioninfo`;
CREATE TABLE `requestfunctioninfo` (
  `Request_ID` int(11) NOT NULL auto_increment,
  `Request_UUID` varchar(36) NOT NULL,
  `ServiceNum_Max` int(11) NOT NULL,
  `LowestReputation` float NOT NULL,
  `Provider_Info` varchar(256) default NULL,
  `Operation_Name` varchar(128) default NULL,
  `MatchGrade` int(11) NOT NULL,
  `Input_Num` int(11) NOT NULL,
  `Output_Num` int(11) NOT NULL,
  `Precondition_Num` int(11) NOT NULL,
  `Result_Num` int(11) NOT NULL,
  `QoSMatchGrade` int(11) NOT NULL,
  `QoS_Num` int(11) NOT NULL,
  PRIMARY KEY  (`Request_ID`),
  KEY `Request_ID` (`Request_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `requestontologymapping`
-- ----------------------------
DROP TABLE IF EXISTS `requestontologymapping`;
CREATE TABLE `requestontologymapping` (
  `Request_ID` int(11) NOT NULL,
  `Ontology_ID` int(11) NOT NULL,
  `Type` int(11) NOT NULL,
  KEY `Request_ID` (`Request_ID`,`Ontology_ID`),
  KEY `FK_RequestOntologyMapping_DomainOntology` (`Ontology_ID`),
  CONSTRAINT `requestontologymapping_ibfk_1` FOREIGN KEY (`Ontology_ID`) REFERENCES `domainontology` (`Ontology_ID`),
  CONSTRAINT `requestontologymapping_ibfk_2` FOREIGN KEY (`Request_ID`) REFERENCES `requestfunctioninfo` (`Request_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `requestparameterinfo`
-- ----------------------------
DROP TABLE IF EXISTS `requestparameterinfo`;
CREATE TABLE `requestparameterinfo` (
  `Request_ID` int(11) NOT NULL,
  `ParameterType` int(11) NOT NULL,
  `ParameterName` varchar(128) default NULL,
  `Concept_ID` int(11) NOT NULL,
  KEY `Request_ID` (`Request_ID`,`Concept_ID`),
  KEY `FK_OntologyConcept_RequestParameterInfo` (`Concept_ID`),
  CONSTRAINT `requestparameterinfo_ibfk_1` FOREIGN KEY (`Concept_ID`) REFERENCES `ontologyconcept` (`Concept_ID`),
  CONSTRAINT `requestparameterinfo_ibfk_2` FOREIGN KEY (`Request_ID`) REFERENCES `requestfunctioninfo` (`Request_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `requestqosinfo`
-- ----------------------------
DROP TABLE IF EXISTS `requestqosinfo`;
CREATE TABLE `requestqosinfo` (
  `Request_ID` int(11) NOT NULL,
  `MatchGrade` int(11) default NULL,
  `Weight` float default NULL,
  `QoS_Metric` int(11) NOT NULL,
  `UpperLimit` float default '3.40282e+038',
  `LowerLimit` float default '-3.40282e+038',
  `QoS_Unit` int(11) default '0',
  KEY `Request_ID` (`Request_ID`,`QoS_Metric`,`QoS_Unit`),
  KEY `FK_OntologyConcept_RequestQoSInfo1` (`QoS_Metric`),
  KEY `FK_OntologyConcept_RequestQoSInfo2` (`QoS_Unit`),
  CONSTRAINT `requestqosinfo_ibfk_1` FOREIGN KEY (`QoS_Metric`) REFERENCES `ontologyconcept` (`Concept_ID`),
  CONSTRAINT `requestqosinfo_ibfk_2` FOREIGN KEY (`Request_ID`) REFERENCES `requestfunctioninfo` (`Request_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `resultidlist`
-- ----------------------------
DROP TABLE IF EXISTS `resultidlist`;
CREATE TABLE `resultidlist` (
  `Request_ID` int(11) NOT NULL,
  `MAC_Address` varchar(50) default NULL,
  `ResultID_List` varchar(800) NOT NULL,
  PRIMARY KEY  (`Request_ID`),
  KEY `Request_ID` (`Request_ID`),
  CONSTRAINT `resultidlist_ibfk_1` FOREIGN KEY (`Request_ID`) REFERENCES `requestfunctioninfo` (`Request_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `servicefunctioninfo`
-- ----------------------------
DROP TABLE IF EXISTS `servicefunctioninfo`;
CREATE TABLE `servicefunctioninfo` (
  `Service_ID` int(11) NOT NULL,
  `Operation_ID` int(11) NOT NULL auto_increment,
  `Operation_UUID` varchar(36) default NULL,
  `ServiceName` varchar(128) NOT NULL,
  `OperationName` varchar(128) NOT NULL,
  `Comment` varchar(800) default NULL,
  `Input_Num` int(11) NOT NULL,
  `Output_Num` int(11) NOT NULL,
  `Precondition_Num` int(11) NOT NULL,
  `Effect_Num` int(11) default NULL,
  `QoS_Num` int(11) NOT NULL,
  PRIMARY KEY  (`Operation_ID`),
  KEY `Service_ID` (`Service_ID`,`Operation_ID`),
  CONSTRAINT `servicefunctioninfo_ibfk_1` FOREIGN KEY (`Service_ID`) REFERENCES `servicemetadata` (`Service_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `servicemetadata`
-- ----------------------------
DROP TABLE IF EXISTS `servicemetadata`;
CREATE TABLE `servicemetadata` (
  `Service_ID` int(11) NOT NULL auto_increment,
  `Service_UUID` varchar(36) default NULL,
  `SemanticFile_NS` varchar(128) NOT NULL,
  `Provider_ID` int(11) NOT NULL,
  `Publish_Time` datetime NOT NULL,
  `WSDL_Address` varchar(258) default NULL,
  `Service_Peputation` float default '0',
  `WSDL_Click` int(11) default '0',
  `OWLS_Click` int(11) default '0',
  `Enable` bit(1) NOT NULL,
  PRIMARY KEY  (`Service_ID`),
  KEY `Service_ID` (`Service_ID`,`Provider_ID`),
  KEY `FK_ServiceMetaData_ProviderInfo` (`Provider_ID`),
  CONSTRAINT `servicemetadata_ibfk_1` FOREIGN KEY (`Provider_ID`) REFERENCES `providerinfo` (`Provider_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=REDUNDANT;

-- ----------------------------
--  Table structure for `serviceontologymapping`
-- ----------------------------
DROP TABLE IF EXISTS `serviceontologymapping`;
CREATE TABLE `serviceontologymapping` (
  `Operation_ID` int(11) NOT NULL default '0',
  `Ontology_ID` int(11) NOT NULL,
  `Type` int(11) NOT NULL,
  KEY `serviceontologymapping_domainontology` (`Ontology_ID`),
  KEY `Operation_ID` (`Operation_ID`,`Ontology_ID`),
  CONSTRAINT `serviceontologymapping_ibfk_1` FOREIGN KEY (`Ontology_ID`) REFERENCES `domainontology` (`Ontology_ID`),
  CONSTRAINT `serviceontologymapping_ibfk_2` FOREIGN KEY (`Operation_ID`) REFERENCES `servicefunctioninfo` (`Operation_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `serviceoperationvector`
-- ----------------------------
DROP TABLE IF EXISTS `serviceoperationvector`;
CREATE TABLE `serviceoperationvector` (
  `Operation_ID` int(11) NOT NULL default '0',
  `Match_Type` int(1) NOT NULL default '0',
  `Vectors` varchar(255) NOT NULL default '',
  KEY `Operation_ID` (`Operation_ID`),
  CONSTRAINT `serviceoperationvector_ibfk_1` FOREIGN KEY (`Operation_ID`) REFERENCES `servicefunctioninfo` (`Operation_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `serviceparameterinfo`
-- ----------------------------
DROP TABLE IF EXISTS `serviceparameterinfo`;
CREATE TABLE `serviceparameterinfo` (
  `Service_ID` int(11) NOT NULL,
  `Operation_ID` int(11) default NULL,
  `Parameter_Type` int(11) NOT NULL,
  `Parameter_Name` varchar(128) NOT NULL,
  `Concept_ID` int(11) NOT NULL,
  KEY `FK_OntologyConcept_ServiceParameterInfo` (`Concept_ID`),
  KEY `Service_ID` (`Service_ID`,`Concept_ID`,`Operation_ID`),
  KEY `serviceparameterinfo_servicefunctioninfo` (`Operation_ID`),
  CONSTRAINT `serviceparameterinfo_ibfk_1` FOREIGN KEY (`Concept_ID`) REFERENCES `ontologyconcept` (`Concept_ID`),
  CONSTRAINT `serviceparameterinfo_ibfk_2` FOREIGN KEY (`Service_ID`) REFERENCES `servicemetadata` (`Service_ID`),
  CONSTRAINT `serviceparameterinfo_ibfk_3` FOREIGN KEY (`Operation_ID`) REFERENCES `servicefunctioninfo` (`Operation_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `serviceqosinfo`
-- ----------------------------
DROP TABLE IF EXISTS `serviceqosinfo`;
CREATE TABLE `serviceqosinfo` (
  `Service_ID` int(11) NOT NULL,
  `Operation_ID` int(11) default NULL,
  `QoS_Metric` int(11) NOT NULL,
  `UpperLimit` float default '3.40282e+038',
  `LowerLimit` float default '-3.40282e+038',
  `QoS_Unit` int(11) default '0',
  KEY `Service_ID` (`Service_ID`,`QoS_Metric`,`QoS_Unit`),
  KEY `FK_OntologyConcept_ServiceQoSInfo1` (`QoS_Metric`),
  KEY `FK_OntologyConcept_ServiceQoSInfo2` (`QoS_Unit`),
  KEY `serviceqosinfo_servicefunctioninfo` (`Operation_ID`),
  CONSTRAINT `serviceqosinfo_ibfk_1` FOREIGN KEY (`QoS_Metric`) REFERENCES `ontologyconcept` (`Concept_ID`),
  CONSTRAINT `serviceqosinfo_ibfk_2` FOREIGN KEY (`Service_ID`) REFERENCES `servicemetadata` (`Service_ID`),
  CONSTRAINT `serviceqosinfo_ibfk_3` FOREIGN KEY (`Operation_ID`) REFERENCES `servicefunctioninfo` (`Operation_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Records 
-- ----------------------------
