/*
 * Author: jmisutka
 * Date: May 14, 2007
 * Time: 9:09:15 PM
 */
package de.dfki.owlsmx.sme2;

import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

/**
 * Application logger
 *
 * @version 1.0 14/05/07
 * @author jmisutka
 */
public class Logger {

    // Disable instantiating
        private Logger () {}

    
    /**
     * Get applicaton logger with preset handlers.
     *
     * @param name logger name
     * @return logger
     */
    public static java.util.logging.Logger getLogger (String name) {

        // get system logger
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger (name);

        // set handler
        ConsoleHandler console = new ConsoleHandler ();
        //console.setFormatter (new SimpleFormatter());
        console.setFormatter (new Formatter() {
            public String format (LogRecord rc) {
                return formatMessage (rc)+"\n";
            }
        });
        logger.addHandler (console);

        // set log level
        logger.setLevel (Level.ALL);

        return logger;
    }



} // class Logger
