package org.act.metaset;

/**
 * class Attribute
 * 
 * @author liujian [liujian@act.buaa.edu.cn]
 * 2005-6-23
 */
public class Attribute implements Cloneable {

	private QName qName = null; // qualified name

	private String value; // value

	//add by cover_eye
	// жϸԪرʽֿռǷǰ׺ʾ
	private boolean attrPrefixFlag = true;

	//end of add by cover_eye

	/**
	 * Construct an attribute using QName and attribute value
	 *
	 * @param qName QName the attribute QName
	 * @param value String the attribute value
	 */
	public Attribute(QName qName, String value) {
		this.qName = qName;
		this.value = value;
	}

	/**
	 * Construct an attribute using String qulified name and attribute value
	 * @param qName String
	 * @param value String
	 */
	public Attribute(String qName, String value) {
		this.qName = new QName(qName);
		this.value = value;
	}

	/**
	 * Set attribute name's namespace
	 *
	 * @param namespace String the attribute's namespace
	 */
	public void setNameSpace(String namespace) {
		qName.setNameSpace(namespace);
	}

	/**
	 * Get attribute's namespace
	 *
	 * @return String the attribute's namespace
	 */
	public String getNameSpace() {
		return qName.getNameSpace();
	}

	/**
	 * Set attribute's name
	 *
	 * @param name String the attribute's name
	 */
	public void setName(String name) {
		qName.setName(name);
	}

	/**
	 * Get attribute name's name
	 *
	 * @return String the attribute's name
	 */
	public String getName() {
		return qName.getName();
	}

	/**
	 * Set attribute's value
	 *
	 * @param value String the attribute's value
	 */
	public void setValue(String value) {
		this.value = value;
	}

	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o instanceof Attribute) {
			Attribute anotherAttribute = (Attribute) o;
			if ((value != null && (anotherAttribute.value != null))) { //add by lh 050628
			//boolean f=value.equals(anotherAttribute.value) ;
				return (qName.getName().equals(anotherAttribute.getName())
						&& qName.getNameSpace().equals(
								anotherAttribute.getNameSpace()) && value
						.equals(anotherAttribute.value));
			}
			//add by lh 050628
			else if ((value == null && anotherAttribute.value != null)
					|| (value != null && anotherAttribute.value == null)) {
				return false;
			} else {
				return (qName.getName().equals(anotherAttribute.getName()) && qName
						.getNameSpace().equals(anotherAttribute.getNameSpace()));
			}
		}

		return false;
	}

	//ֻһǳ
	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}

	/**
	 * Get attribute value
	 *
	 * @return String the attribute's value
	 */
	public String getValue() {
		return value;
	}

	public String toString() {
		return qName.toString() + "=\"" + normalize(value) + "\"";
	}

	private static String normalize(String s) {
		StringBuffer str = new StringBuffer();
		int len = (s != null) ? s.length() : 0;

		for (int i = 0; i < len; i++) {
			char ch = s.charAt(i);

			switch (ch) {
			case '<': {
				str.append("&lt;");
				break;
			}
			case '>': {
				str.append("&gt;");
				break;
			}
			case '&': {
				str.append("&amp;");
				break;
			}
			case '"': {
				str.append("&quot;");
				break;
			}
			case NL: {
				if (i > 0) {
					char lastChar = str.charAt(str.length() - 1);

					if (lastChar != CR) {
						str.append(LS);
					} else {
						str.append(NL);
					}
				} else {
					str.append(LS);
				}
				break;
			}
			default: {
				str.append(ch);
			}
			}
		}

		return (str.toString());
	}

	public static final char NL = '\n';

	public static final char CR = '\r';

	/**
	 * The prefered line separator
	 */
	public static final String LS = System.getProperty("line.separator",
			(new Character(NL)).toString());

	//add by cover_eye:2006-11-15
	/**
	 * get the attrPrefixFlag
	 * @return attrPrefixFlag
	 */
	public boolean isAttrPrefixFlag() {
		return attrPrefixFlag;
	}

	/**
	 * set the attrPrefixFlag
	 * @param attrPrefixFlag
	 */
	public void setAttrPrefixFlag(boolean attrPrefixFlag) {
		this.attrPrefixFlag = attrPrefixFlag;
	}
	//end of add by cover_eye

}
