package org.act.metaset;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import org.act.metaset.expression.ElementExpression;
import org.act.metaset.expression.Expression;

/**
 * class ServicesSet
 * ServicesSetXMLṹ״ʾ
 * @author liujian [liujian@act.buaa.edu.cn]
 * 2005-6-23
 */
public class Metaset implements Cloneable {

	/**
	 * XMLԪصԪֿռ
	 */
	private String namespace = null;

	//add by cover_eye
	/**
	 * XMLԪصtargetNamespace
	 */
	private String targetNamespace=null;
	/**
	 * XMLԪصĬֿռ
	 */
	private String defaultNamespace=null;
	/**
	 * XMLԪصռб
	 */
	private Map namespaceMap=null;
	//end of add by cover_eye

	/**
	 * XMLԪصԪ
	 */
	private String name = null;

	/**
	 * XMLԪصԪֵ
	 */
	private String value = "";//null;

	/**
	 * XMLԪصĸԪ
	 */
	private Metaset father = null;

	/**
	 * XMLԪصԼ
	 */
	private ArrayList attributes = null;

	/**
	 * XMLԪصԪؼ
	 */
	private ArrayList childs = null;

	/**
	 * ServicesSet·ָ
	 */
	public static final String SEPERATOR = "\\";

	/**
	 * XMLĵı뷽ʽ
	 */
	private String encoding = "GB2312";

	/**
	 * Construct a ServicesSet using empty element's namespace and empty element's name
	 */
	public Metaset() {
		this("", "");
	}

	/**
	 * Construct a ServicesSet using empty element's namespace and element's name
	 * @param name String the ServiceSet's element's name
	 */
	public Metaset(String name) {
		this("", name);
	}

	/**
	 * Construct a ServicesSet using element's <code>QName<code>
	 * @param qName QName the ServiceSet's qulified name
	 * @see QName
	 */
	public Metaset(QName qName) {
		this(qName.getNameSpace(),qName.getName());
	}

	/**
	 * Construct a ServicesSet using element's namespace and element's name
	 * @param namespace String ServicesSet's element's namespace
	 * @param name String the ServicesSet's element's name
	 */
	public Metaset(String namespace, String name) {
		this.namespace = namespace;
		this.name = name;
	}

	/**
	 * Construct a ServicesSet from a xml file
	 * @param path String the xml file full path
	 * @return ServicesSet the <code>ServicesSet</code> constructed from the xml file
	 * @throws Exception when exception occured.
	 */
	public static Metaset create(String path) throws Exception {
		Metaset results = MetasetParser.getInstance().parse(new FileInputStream(path));
		dealImport(results);
		return results;
	}

	// Construct a Metaset from input stream.
	// s- a String with xml content, ss--no value
	public static Metaset create(String s,String ss) throws Exception {
		InputStream  in  = new ByteArrayInputStream(s.getBytes());
		Metaset results = MetasetParser.getInstance().parse(in);
		dealImport(results);
		return results;
	}
	
	/**
	 * Deal with the import element in the "definitions//import"
	 * @param current the current <code>ServicesSet</code>
	 */
	private static void dealImport(Metaset current) {
		//TODO This may rise error when the file have reference to each other.
		//modified by cover_eye:2006-12-9
//		Collection importURL =
//		current.selectors("definitions//import", "location");
		Collection importURL =
			current.selectors("definitions\\import@location");
		if (importURL != null) {
			for (Iterator iter = importURL.iterator(); iter.hasNext();) {
				String element = (String) iter.next();
				MetasetParser p = new MetasetParser();
				Metaset temp = null;
				try {
					temp = p.parse(new FileInputStream(element));
				} catch (FileNotFoundException e) {
					e.printStackTrace();
				}
				if (temp != null) {
					Metaset tmp;
					//document has definition
					if (temp.filter("definitions") != null) {
						tmp = (Metaset)temp.getChilds().get(0);
						dealImport(tmp);
					} else {
						tmp = temp;
						dealImport(tmp);
					}
					for (int j = 0; j < tmp.getChilds().size(); j++) {
						current.add((Metaset)tmp.getChilds().get(j));
					}
				}
			}
		}
	}

	/**
	 * Set the element's namespace
	 * @param value String the ServicesSet's element namespace
	 */
	public void setNamespace(String value) {
		namespace = value;
	}

	/**
	 * Get the element's namespace
	 * @return String the ServicesSet's element namespace
	 */
	public String getNamespace() {
		return namespace;
	}

	/**
	 * Set the element's name
	 * @param name String the ServicesSet's element name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Get the element's name
	 * @return String  the ServicesSet's element name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Set the element's value
	 * @param value String the ServicesSet's element value
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * Get the element's value
	 * @return String the ServicesSet's element value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * Set the element's father
	 * @param father ServicesSet the element's father element
	 */
	public void setFather(Metaset father) {
		this.father = father;
	}

	/**
	 * Get the element's father
	 * @return ServicesSet the element's father element
	 */
	public Metaset getFather() {
		return father;
	}

	/**
	 * @return Returns the encoding.
	 */
	public String getEncoding() {
		return encoding;
	}

	/**
	 * @param encoding The encoding to set.
	 */
	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}

	/**
	 * Get the element's attributes, the item in the result list
	 * are of type <code>org.act.servicesset.Attribute</code>
	 * @return the element's attributes
	 * @see org.act.metaset.Attribute
	 */
	public List getAttributes() {
		if (attributes==null) {
			attributes = new ArrayList();
		}
		return attributes;
	}

	/**
	 * Get the element's child elements, the item in the result list
	 * are of type <code>org.act.servicesset.ServicesSet</code>
	 * @return the element's child elements
	 */
	public List getChilds() {
		if (childs==null) {
			childs = new ArrayList();
		}
		return childs;
	}

	/**
	 * Transform the servicesset into xml.
	 * @return the xml segment of this servicesset.
	 */
	public String toXML() {
		String result = "";
		String qName = "";
		if (name == "") {
			for (int j = 0; j < getChilds().size(); j++) {
				result += ((Metaset) getChilds().get(j)).toXML(); //getChildSet(j).toXML();
			}
		} else {
			if (namespace != "") {
				qName = namespace + ":" + name;
			} else {
				qName = name;
			}
			result = "<" + qName;
			for (int i = 0; i < getAttributes().size(); i++) {
				Attribute attr = (Attribute) attributes.get(i);
				if (attr.getName() != "name") {//lh
					if (attr.getValue() != null
							&& !attr.getValue().equals("")) {
						result += " " + attributes.get(i).toString();
					}
				} else {
					result += " " + attributes.get(i).toString();
				}
			}
			if (getChilds().size() > 0) {
				result += ">\n"; //
				for (int j = 0; j < getChilds().size(); j++) {
					result += ((Metaset) getChilds().get(j)).toXML();
				}
				result += "</" + qName + ">\n"; //
			} else if (value != "") {
				result += ">"; //
				result += normalize(value) + ""; //
				result += "</" + qName + ">\n"; //
			} else {
				result += "/>\n"; //
			}
		}
		return result;
	}

	/**
	 * Transform the servicesset into xml.
	 * 
	 * @return the xml segment of this servicesset.
	 */
	public String toXMLModel() {
		String result = "";
		String qName = "";
		if (name == "") {
			for (int j = 0; j < getChilds().size(); j++) {
				result += ((Metaset) getChilds().get(j)).toXMLModel(); //getChildSet(j).toXML();
			}
		} else {
			if (namespace != "") {
				qName = namespace + ":" + name;
			} else {
				qName = name;
			}
			result = "<" + qName;
			for (int i = 0; i < getAttributes().size(); i++) {
				Attribute attr = (Attribute) attributes.get(i);
				//if () {//lh
				if (attr.getName().equals("debugId")
						|| attr.getName().equals("breakPoint")) {//lh0908
					// bebug״̬£bpelĵbreakidbreakpoint¼
					//result += "";
				} else if (attr.getName().equals("name")){
					if (attr.getValue() != null
							&& !attr.getValue().equals("")) {
						result += " " + attributes.get(i).toString();
					}
				}

				//} 
				else {
					result += " " + attributes.get(i).toString();
				}
			}
			if (getChilds().size() > 0) {
				result += ">\n"; //
				for (int j = 0; j < getChilds().size(); j++) {
					result += ((Metaset) getChilds().get(j)).toXMLModel();
				}
				result += "</" + qName + ">\n"; //
			} else if (value != "") {
				result += ">"; //
				result += normalize(value) + ""; //
				result += "</" + qName + ">\n"; //
			} else {
				result += "/>\n"; //
			}
		}
		return result;
	}

	/**
	 * Transform the servicesset into document.
	 * @return the xml document of this servicesset.
	 */
	public String toDocument() {
		if (encoding==null) {
			return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + toXML();
		}
		else {
			return "<?xml version=\"1.0\" encoding=\""+encoding+"\"?>" + toXML();
		}
	}
	//add by cover_eye:2006-12-9
	public Metaset filter(String path){
		Expression expression=new Expression(path);
		return this.filter(expression);
	}
	
	public Metaset filter(String path, String an) {
		return filter(path+"@"+an);
	}
	
	public Metaset filter(String path, String an, String av) {
		return filter(path+"@"+an+"=\""+av+"\"");
	}
	
	/**
	 * ӵǰServicesSetѡ·ʽΪexpressionServicesSet<br/>
	 * @author cover_eye
	 * @param path·Expression
	 * @return ServicesSet
	 * 
	 * TODO:Ԫƶֿռ֧
	 */
	private Metaset filter(Expression expression) {
		String elementName = "";
		String elementNamespace = "";
		List attrList = new ArrayList();

		String attrName = "";
		String attrNamespace = "";

		Stack stack = new Stack();
		ArrayList resultList = new ArrayList();
		stack.push(this);

		List elements = expression.getElementList();
		for (Iterator iter = elements.iterator(); iter.hasNext();) {
			Stack tmp = new Stack();
			ElementExpression element = (ElementExpression) iter.next();
			elementName = element.getElementName();
			elementNamespace = element.getElementNamespace();
			attrList = element.getAttrList();
			if (!elementName.trim().equals("*")) {
				while (!stack.empty()) {
					Metaset ss = (Metaset) stack.pop();
					//޸:2006-11-15
					if (elementName.trim().equals(".") 
							||elementName.trim().equals("#")
							|| ( elementName.equals(ss.getName())
									&&(elementNamespace.equals("")//ѡ·²elementռ
											||(element.isElemPrefixFlag()&&elementNamespace.equals(ss.getNamespace()))//ѡ·elementռǰ׺
											||(!element.isElemPrefixFlag()&&elementNamespace.equals(ss.getActualNamespace()))//ѡ·elementռuri
									) 
							)
					) {
						boolean flag1=true;
						for (Iterator iterator = attrList.iterator(); iterator.hasNext();) {
							boolean flag2=false;
							Attribute attribute = (Attribute) iterator.next();
							attrName=attribute.getName();
							attrNamespace=attribute.getNameSpace();
							for (int k = 0; k < ss.getAttributes().size(); k++) {
								Attribute p = (Attribute)ss.getAttributes().get(k);
								//޸:2006-11-15
								String tempNamespace4attr=p.getNameSpace();
								//ԵռΪ,ռԪصռ
								if(tempNamespace4attr.equals("")) 
									tempNamespace4attr=ss.getNamespace();			
								if (attrName.equals(p.getName())
										&&(attrNamespace.equals("")//ѡ·²attributeռ
												||(attribute.isAttrPrefixFlag()&&attrNamespace.equals(tempNamespace4attr))//ѡ·attributeռǰ׺
												||(!attribute.isAttrPrefixFlag()&&attrNamespace.equals(this.getActualNamespace(ss,tempNamespace4attr)))//ѡ·attributeռuri
										)
								){
									if(attribute.getValue().equals("")||attribute.getValue().equals(p.getValue())){
										flag2=true;
									}
								}
							}
							if(!flag2) {
								flag1=false;break;
							}	
						}
						if(!flag1) continue;
						else if (!iter.hasNext()) {
							resultList.add(ss);
						} else {
							for (int j = 0; j < ss.getChilds().size(); j++) {
								tmp.push(ss.getChilds().get(j));
							}
						}
					}
				}
			} else {
				while (!stack.empty()) {
					Metaset ss = (Metaset) stack.pop();
					if (!iter.hasNext()) {
						resultList.add(ss);
					} else {
						for (int i = 0; i < ss.getChilds().size(); i++) {
							tmp.push(ss.getChilds().get(i));
						}
					}
				}
			}
			stack = tmp;
		}

		if (resultList.isEmpty()) {
			return null;
		} else {
			Metaset result = new Metaset();
			for (int i = resultList.size() - 1; i >= 0; i--) {
				result.add((Metaset) resultList.get(i));
			}
			return result;
		}

	}	
//	end by cover_eye

//	add by cover_eye:2006-11-11
	/**
	 * ѡѡ·ʽµĵһԪصԵֵ
	 * @author cover_eye
	 * @param expression:·ʽ
	 * @return ѡ·ʽµĵһԪصҪֵ
	 */
	public String selector(String path) {
		Expression expression=new Expression(path);
		Metaset tmp = filter(expression);
		if (tmp != null) {
			List elementList = expression.getElementList();
			ElementExpression lastElement = (ElementExpression) elementList
			.get(elementList.size() - 1);
			String lastElementName = lastElement.getElementName();
			//FIXME Ŀǰͨ "."ԪƣΪƥWebʽлҪ½ж塣
			//liujian 2007-07-01

			if (lastElementName.equals("#")||(lastElementName.equals(".")&&lastElement.getAttrList().size()==0)) {
				//ذԵԪ
				return ((Metaset) tmp.getChilds().get(0)).getName();
			} else {
				//TODO liujian 2007-06-30
				if (lastElement.getAttrList().size()>0) {
				Attribute attribute = (Attribute) lastElement.getAttrList().get(0);
				String attrName = attribute.getName();
				String attrNamespace = attribute.getNameSpace();
				for (int i = 0; i < tmp.getChilds().size(); i++) {
					Metaset temp = (Metaset) tmp.getChilds().get(i);
					for (int j = 0; j < temp.getAttributes().size(); j++) {
						Attribute p = (Attribute) temp.getAttributes().get(j);
						//޸:2006-11-15
						String tempNamespace4attr=p.getNameSpace();
						//ԵռΪ,ռԪصռ
						if(tempNamespace4attr.equals("")) 
							tempNamespace4attr=temp.getNamespace();	
						if (attrName.equals(p.getName())
								&&(attrNamespace.equals("")//ѡ·²attributeռ
										||(attribute.isAttrPrefixFlag()&&attrNamespace.equals(tempNamespace4attr))//ѡ·attributeռǰ׺
										||(!attribute.isAttrPrefixFlag()&&attrNamespace.equals(this.getActualNamespace(temp,tempNamespace4attr)))//ѡ·attributeռuri
								)
						)
							return p.getValue();
					}
				}
				}

			}
		}
		return null;
	}
	
	public String selector(String path, String an) {
		if (path.equals(".\\"))
			return selector(".@"+an);
		return selector(path+"@"+an);
	}
	
//	public String selector(String path, String an, String av) {
//		
//	}
	
	/**
	 * ѡѡ·ʽµԪصԵֵб
	 * @author cover_eye
	 * @param expression:·ʽ
	 * @return ѡ·ʽµԪصԵֵ
	 */
	public Collection selectors(String path) {
		Expression expression=new Expression(path);
		List result = new ArrayList();
		Metaset tmp = filter(expression);
		if (tmp != null) {
			List elementList = expression.getElementList();
			ElementExpression lastElement = (ElementExpression) elementList
			.get(elementList.size() - 1);
			String lastElementName = lastElement.getElementName();
			if (lastElementName.equals("#")) {
				for (int i = 0; i < tmp.getChilds().size(); i++){
					result.add( ((Metaset) tmp.getChilds().get(i)).getName());
				}
				return result;
			} else {
				Attribute attribute = (Attribute) lastElement.getAttrList().get(0);
				String attrName = attribute.getName();
				String attrNamespace = attribute.getNameSpace();
				for (int i = 0; i < tmp.getChilds().size(); i++) {
					Metaset temp = (Metaset) tmp.getChilds().get(i);
					for (int j = 0; j < temp.getAttributes().size(); j++) {
						Attribute p = (Attribute) temp.getAttributes().get(j);
						String tempNamespace4attr=p.getNameSpace();
						//ԵռΪ,ռԪصռ
						if(tempNamespace4attr.equals("")) 
							tempNamespace4attr=temp.getNamespace();	
						if (attrName.equals(p.getName())
								&&(attrNamespace.equals("")//ѡ·²attributeռ
										||(attribute.isAttrPrefixFlag()&&attrNamespace.equals(tempNamespace4attr))//ѡ·attributeռǰ׺
										||(!attribute.isAttrPrefixFlag()&&attrNamespace.equals(this.getActualNamespace(temp,tempNamespace4attr)))//ѡ·attributeռuri
								)
						)
							result.add(p.getValue());
					}						
				}
				return result; 
			}
		}
		return null;
	}
//	end by cover_eye		

	/**
	 * Add an attribute into ServicesSet
	 * @param attribute Attribute the attribute added to ServicesSet
	 */
	public void add(Attribute attribute) {
		if (!getAttributes().contains(attribute)) {
			getAttributes().add(attribute);
		}
	}

	/**
	 * Add a ServicesSet into current ServicesSet
	 * @param child ServicesSet the ServicesSet added into the current ServicesSet
	 */
	public void add(Metaset child) {
		getChilds().add(child);
	}

	//add by cover_eye:2006-11-12
	/**
	 * Add an Attribute into all the ServicesSet in the filter path
	 * @author cover_eye
	 * @param expression:the filter expression
	 * @param attribute:the attribute 
	 */
	public void add(String path,Attribute attribute){
		Expression expression=new Expression(path);
		Metaset result = filter(expression);
		if (result != null && (result.getChilds().size() > 0)){
			for(int i=0;i<result.getChilds().size();i++)
			{
				((Metaset)result.getChilds().get(i)).add(attribute);
			}
		}
	}
	/**
	 * Add a serviceset into all the ServicesSet in the filter path
	 * @author cover_eye
	 * @param expression:the filter expression
	 * @param child:the serviceset
	 */
	public void add(String path,Metaset child){
		Expression expression=new Expression(path);
		Metaset result = filter(expression);
		if (result != null && (result.getChilds().size() > 0)){
			for(int i=0;i<result.getChilds().size();i++)
			{
				((Metaset)result.getChilds().get(i)).add(child);
			}
		}
	}
	//end by cover_eye

	public void add(String path, String an, Metaset child) {
		add(path+"@"+an, child);
	}
	
	public void add(String path,String an, String av, Metaset child) {
		add(path+"@"+an+"=\""+av+"\"",child);
	}

	/**
	 * Remove an attribute from the attribute list.
	 * @param attribute the attribute to remove
	 * @return if the attribute removed, true for removed, otherwise false.
	 */
	public boolean remove(Attribute attribute) {
		if (getAttributes().contains(attribute)) {
			return attributes.remove(attribute);
		}
		return false;
	}

	/**
	 * Remove an services set from the services set list.
	 * @param ss the services set to remove
	 * @return if the services set removed, true for removed, otherwise false.
	 */
	public boolean remove(Metaset ss) {
		if (getChilds().contains(ss)) {
			return getChilds().remove(ss);
		}
		return false;
	}

	//add by cover_eye:20006-11-12
	/**
	 * 
	 * remove an Attribute from all the ServicesSet in the filter path
	 * @author cover_eye
	 * @param expression:the filter expression
	 * @param attribute:the attribute 
	 * @return the result
	 */
	public boolean remove(String path,Attribute attribute){
		Expression expression=new Expression(path);
		Metaset result = filter(expression);
		if (result != null && (result.getChilds().size() > 0)){
			for(int i=0;i<result.getChilds().size();i++)
			{
				boolean flag4oneResult=((Metaset)result.getChilds().get(i)).remove(attribute);
				if(!flag4oneResult) return false;
			}
			return true;
		}
		return false;
	}

	/**
	 * 
	 * remove a serviceset from all the ServicesSet in the filter path
	 * @author cover_eye
	 * @param expression:the filter expression
	 * @param child:the serviceset
	 * @return:the result
	 */
	public boolean remove(String path,Metaset child){
		Expression expression=new Expression(path);
		Metaset result = filter(expression);
		if (result != null && (result.getChilds().size() > 0)){
			for(int i=0;i<result.getChilds().size();i++)
			{
				boolean flag4oneResult=((Metaset)result.getChilds().get(i)).remove(child);
				if(!flag4oneResult) return false;
			}
			return true;
		}
		return false;
	}
	//end by cover_eye

	  public void remove(String path) {
		    Metaset result = filter(path);
		    if ((result!=null) && (result.getChilds().size()>0)) {
		      for (int i=0; i<result.getChilds().size(); i++) {
		        ((Metaset)result.getChilds().get(i)).getFather().remove((Metaset)result.getChilds().get(i));
		      }
		    }
		  }
		  
		  public void remove(String path, String an) {
			  Metaset result = filter(path+"@"+an);
		    if ((result!=null) && (result.getChilds().size()>0)) {
		      for (int i=0; i<result.getChilds().size(); i++) {
		    	  Metaset set = (Metaset) result.getChilds().get(i);//.getChildSet(i);
		        for (int j = 0; j < set.getAttributes().size(); j++) {
					Attribute attr = (Attribute)set.getAttributes().get(j);//.getAttribute(j);
					if (attr.getName().equals(an)) {
						set.remove(attr);
						break;
					}
				}
		      }
		    }
		  }
		  
		  public void remove(String path, String an, String av) {
			  Metaset result = filter(path+"@"+an+"="+av);
		    if ((result!=null) && (result.getChilds().size()>0)) {
		      for (int i=0; i<result.getChilds().size(); i++) {
		    	  Metaset set = (Metaset) result.getChilds().get(i);//.getChildSet(i);
		          for (int j = 0; j < set.getAttributes().size(); j++) {
		  			Attribute attr = (Attribute)set.getAttributes().get(j);;
		  			if (attr.getName().equals(an) && attr.getValue().equals(av)) {
		  				set.remove(attr);
		  				break;
		  			}
		  				
		  		}
		      }
		    }
		  }
		  
	/**
	 * ǳ
	 * @return the cloned object.
	 * @see Object#clone()
	 * @throws CloneNotSupportedException when clone is not supported.
	 */
	public Object clone() throws CloneNotSupportedException {
		Metaset result = (Metaset) super.clone();
		if (attributes!=null) {
			result.attributes = new ArrayList();
			for (int i=0; i<this.attributes.size(); i++) {
				Attribute attr = (Attribute)this.attributes.get(i);
				result.attributes.add(attr.clone());
			}
		}
		if (childs!=null) {
			result.childs = new ArrayList();
			for (int i=0; i<this.childs.size(); i++) {
				Metaset ss = (Metaset) ((Metaset) this.childs.get(i)).clone();
				ss.setFather(result);
				result.childs.add(ss);
			}
		}
		//result.attributes = (ArrayList) this.attributes.clone();
		//result.childs = (ArrayList) this.childs.clone();
		return result;
	}

	/**
	 * Return the first child services set in the services set list.
	 * @return the first child services set in the services set list.
	 */
	public Metaset car() {
		if (getChilds().size() > 0) {
			return (Metaset)getChilds().get(0);
		}
		return null;
	}

	//TODO liujian 2005-08-31
	public Metaset car(String path) {
		return null;
	}

	//TODO liujian 2005-08-31
	public Metaset cdr(String path) {
		return null;
	}

	/**
	 * Remove the first child services set in the services set list, and return the rest of the services set.
	 * @return the services set which first child services set is removed.
	 */
	public Metaset cdr() {
		if (getChilds().size() > 0) {
			getChilds().remove(0);
		}
		return null;
	}

	/**
	 * Return the height of the services set.
	 * @return the height of the services set.
	 */
	public int getHeight() {
		if (this.childs.size() == 0) {
			return 0;
		}
		int height = 0;
		for (int i = 0; i < childs.size(); i++) {
			Metaset ss = (Metaset) getChilds().get(i);
			int tmp = ss.getHeight();
			if (tmp > height) {
				height = tmp;
			}
		}
		return height + 1;
	}

	/**
	 * Return the leaf number of the services set.
	 * @return the leaf number of the services set.
	 */
	public int getLeafCount() {
		if (this.childs.size() == 0) {
			return 1;
		}
		int count = 0;
		for (int i = 0; i < childs.size(); i++) {
			Metaset ss = (Metaset) childs.get(i);
			count += ss.getLeafCount();
		}
		return count;
	}
	/**
	 * @param o the compared object
	 * @return if the two object are equal.
	 * @see Object#equals(Object)
	 */
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		} else {
			Metaset other = (Metaset) o;
			boolean result = true;
			result =
				this.name.equals(other.name)
				&& this.namespace.equals(other.namespace)
				&& ((value==null && other.value==null)||this.value.equals(other.value))
				//&& (this.father == other.father)
				&& (this.getAttributes().size() == other.getAttributes().size())
				&& (this.getChilds().size() == other.getChilds().size());
			if (!result) {
				return result;
			}
			for (int i = 0; i < this.getAttributes().size(); i++) {
				result =
					result
					&& this.getAttributes().get(i).equals(other.getAttributes().get(i));
				if (!result) {
					return result;
				}
			}
			for (int i = 0; i < this.getChilds().size(); i++) {
				//
				//System.out.println("ServicesSet.equals()");
				result =
					result && ((Metaset)this.getChilds().get(i)).equals(other.getChilds().get(i));
				if (!result) {
					return result;
				}
			}
			return true;
		}
	}

	/**
	 * Return if the current services set have child services set.
	 * @return if the current services set have child services set.
	 */
	public boolean isEmpty() {
		return getChilds().size() == 0;
	}

	//add by lh 050607
	/**
	 * newSs丸λ
	 * 
	 * @param newSs
	 *            ServicesSet
	 * @return int
	 */
	public int getServicesSetPosition(Metaset newSs) {

		int i = this.getChilds().indexOf(newSs);
		return i;
	}

	/**
	 * childλposition
	 * 
	 * @param child
	 *            ServicesSet
	 * @param position
	 *            int
	 */
	public void insert(Metaset child, int position) {
		Metaset temp = null;
		getChilds().add(temp);
		for (int i = getChilds().size() - 2; i >= position; i--) {
			temp = (Metaset) getChilds().get(i);
			if (i - 1 >= 0) {
				getChilds().set(i, getChilds().get(i - 1));
			}
			getChilds().set(i + 1, temp);
		}
		getChilds().set(position, child);
	}

	private static String normalize (String s) {
		StringBuffer str = new StringBuffer();
		int len = (s != null) ? s.length() : 0;

		for (int i = 0; i < len; i++) {
			char ch = s.charAt(i);

			switch (ch) {
			case '<': {
				str.append("&lt;");
				break;
			}
			case '>': {
				str.append("&gt;");
				break;
			}
			case '&': {
				str.append("&amp;");
				break;
			}
			case '"': {
				str.append("&quot;");
				break;
			}
			case NL: {
				if (i > 0) {
					char lastChar = str.charAt(str.length() - 1);

					if (lastChar != CR) {
						str.append(LS);
					}
					else {
						str.append(NL);
					}
				}
				else {
					str.append(LS);
				}
				break;
			}
			default: {
				str.append(ch);
			}
			}
		}

		return (str.toString());
	}

	public static final char NL = '\n';

	public static final char CR = '\r';

	/**
	 * The prefered line separator
	 */
	public static final String LS = System.getProperty("line.separator",
			(new Character(NL)).toString());

	//  add by cover_eye
	/**
	 * Get the element's defult namespace
	 * @return String the ServicesSet's  default namespace
	 */

	public String getDefaultNamespace() {
		Metaset current = this;
		while (current!= null&&current.defaultNamespace==null) {
			current = current.getFather();
		}
		return current.defaultNamespace;
	}
	/**
	 * Set the element's default namespace
	 * @param value String the ServicesSet's  default namespace
	 */
	public void setDefaultNamespace(String defaultNamespace) {
		this.defaultNamespace = defaultNamespace;
	}
	/**
	 * Get the element's target namespace
	 * @return String the ServicesSet's  target namespace
	 */
	public String getTargetNamespace() {
		Metaset current = this;
		while (current!= null&&current.targetNamespace==null) {
			current = current.getFather();
		}
		return current.targetNamespace;
	}
	/**
	 * Set the element's target namespace
	 * @param value String the ServicesSet's  target namespace
	 */
	public void setTargetNamespace(String targetNamespace) {
		this.targetNamespace = targetNamespace;
	}
	/**
	 * add namespace to the ServicesSet's NamespaceMap
	 * @param attr:the attribute that contain namespace...
	 */
	public void addNamespace2Map(Attribute attr){
		if(namespaceMap==null){
			namespaceMap = new HashMap();
		}
		namespaceMap.put(attr.getName(),attr);
	}
	/**
	 * get the Map of the ServicesSet's namespaces 
	 * @return the ServicesSet's namespaces
	 */
	public Map getNamespaceMap() {
		if (namespaceMap==null) {
			namespaceMap = new HashMap();
		}
		return namespaceMap;
	}
	/**2006-11-15
	 * get the namespace uri of this ServiceSet
	 * @return the namespace uri
	 */
	public String getActualNamespace() {
		Metaset current = this;
		String prefix = current.namespace;
		return getActualNamespace(current,prefix);
	}
	/**2006-11-15
	 * get the namespace uri of the prefix in the "current" serviceSet
	 * @param current:the serviceSet
	 * @param prefix:the prefix
	 * @return the namespace uri
	 */
	public final String getActualNamespace(Metaset current,String prefix) {
		if (prefix.equals("") || prefix == null)
			return current.getDefaultNamespace();
		else {
			String actualNamespace = "";
			do {
				Map tempMap = current.getNamespaceMap();
				if (tempMap.size() > 0 && tempMap.containsKey(prefix)) {
					Attribute attr = (Attribute) tempMap.get(prefix);
					actualNamespace = attr.getValue();
					break;
				}
				current = current.getFather();
			} while (current != null);
			return actualNamespace;
		}
	}
	//end of add by cover_eye
}
