package org.act.metaset;

import java.io.InputStream;
import java.util.ArrayList;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * class SAXServicesSetParser
 * 
 * @author liujian [liujian@act.buaa.edu.cn]
 * 2005-6-23
 */
public class MetasetParser {

	/**
	 * Parse an InputStream and return a ServiceSet
	 *
	 * @param in InputStream the input stream
	 * @return ServiceSet Return the ServiceSet
	 */
	public Metaset parse(InputStream in) {
		ServiceSetContentHandler handler = new ServiceSetContentHandler();
		SAXParserFactory factory = SAXParserFactory.newInstance();
		try {
			SAXParser saxParser = factory.newSAXParser();
			saxParser.parse(in, handler);
			//saxParser.getXMLReader().//
		} catch (Exception ex) {
			ex.printStackTrace();
			return null;
		}
		return handler.getResult();
	}
	
	/**
	 * õSingletonģʽ,ҪǱ֤JavaӦóУһClassֻһʵڡ 
	   һSingletonģʽͨмʽ: 
		һʽ: һ࣬Ĺ캯ΪprivateģһstaticprivateĸʼʱʵͨһpublicgetInstanceȡ,̶еķ 
		public class Singleton { 
		private Singleton(){} 
		//ԼڲԼһʵǲǺ֣ 
		//עprivate ֻڲ 
		private static Singleton instance = new Singleton(); 
		//ṩһⲿʱclassľֱ̬ӷʡ 
		public static Singleton getInstance() { 
		return instance;  
		 } 
		} 
		ڶʽ: 
		public class Singleton { 
		private static Singleton instance = null; 
		public static synchronized Singleton getInstance() { 
		//ĽÿζɶֻǵһΡ  
		//ʹʱʵЧʣ 
		if (instance==null) 
		instancenew Singleton(); 
		return instance; } 
		} 
		ʽ: 
		һ࣬Ĺ캯ΪprivateģзΪstaticġ 
		һΪһʽҪӰȫЩ
	**/
	private static MetasetParser instance;
	public static MetasetParser getInstance() {
		if (instance == null) {
			instance = new MetasetParser();
		}
		return instance;
	}
}

      /**
       * ServicesSetݴ
       * @author liujian
       * @version 1.0
       */

class ServiceSetContentHandler extends DefaultHandler {

	private ArrayList stack = new ArrayList();
	private Metaset result = null;
	private boolean isEndElement = true;
	/**
	 * Deal with start element.
	 *
	 * @param namespaceURI String
	 * @param localName String
	 * @param qName String
	 * @param atts Attributes
	 * @throws SAXException
	 */
	public void startElement(
		String namespaceURI,
		String localName,
		String qName,
		Attributes atts)
		throws SAXException {
		QName qname = new QName(qName);
		Metaset tmp =
			new Metaset(qname.getNameSpace(), qname.getName());
		for (int i = 0; i < atts.getLength(); i++) {
			Attribute param =
				new Attribute(new QName(atts.getQName(i)), atts.getValue(i));
			tmp.add(param);
			//add by cover_eye
			if(param.getName()=="targetNamespace")
				tmp.setTargetNamespace(param.getValue());
			else if(param.getName()=="xmlns")
				tmp.setDefaultNamespace(param.getValue());
			else if(param.getNameSpace().equals("xmlns"))
				tmp.addNamespace2Map(param);
			//end of add by cover_eye
		}
		if (stack.size() != 0) {
			Metaset father = (Metaset) stack.get(stack.size() - 1);
			father.add(tmp);
			tmp.setFather(father);
		} else {
			result = tmp;
		}
		stack.add(tmp);
	}

	/**
	 * Deal with end element.
	 *
	 * @param namespaceURI String
	 * @param localName String
	 * @param qName String
	 * @throws SAXException
	 */
	public void endElement(String namespaceURI, String localName, String qName)
		throws SAXException {
		stack.remove(stack.size() - 1);
		isEndElement = true;
	}

	/**
	 * Deal with characters
	 *
	 * @param ch char[]
	 * @param start int
	 * @param length int
	 * @throws SAXException
	 */
	public void characters(char[] ch, int start, int length)
		throws SAXException {
		isEndElement = false;
		String str = new String(ch, start, length);
		if (!str.trim().equals("")) {
			Metaset tmp = (Metaset) stack.get(stack.size() - 1);
			if (!isEndElement) {
				if (tmp.getValue()!=null) {
					tmp.setValue(tmp.getValue() + str);
				}
				else {
					tmp.setValue(str);
				}
			}
		}
	}

	/**
	 * Return the result ServiceSet
	 *
	 * @return ServiceSet the result ServiceSet
	 */
	public Metaset getResult() {
		return result;
	}
	
	public void processingInstruction(String target,String data) {
		System.err.println(target+":"+data);
	}
}
