package org.act.metaset;

/**
 * class QName
 * 
 * @author liujian [liujian@act.buaa.edu.cn]
 * 2005-6-23
 */
public class QName {
	private String name = null;
	private String namespace = "";

	/**
	 * Construct a QName using a qualified name
	 * @param qName String the qualified name
	 */
	public QName(String qName) {
		//hehj indexof Ϊlastindexof...
		int pos = qName.lastIndexOf(":");
		if (pos >= 0) {
			namespace = qName.substring(0, pos);
			name = qName.substring(pos + 1);
		} else {
			name = qName;
		}
	}

	/**
	 * Construct a QName using namespace and name
	 * @param namespace String the qualified name's namespace
	 * @param name String the qualified name's name
	 */
	public QName(String namespace, String name) {
		if (namespace==null || name==null) {
			throw new IllegalArgumentException();
		}
		this.namespace = namespace;
		this.name = name;
	}

	/**
	 * Return the qualified name's name
	 *
	 * @return String the qualified name's name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Return the qualified name's namespace
	 *
	 * @return String the qualified name's namespace
	 */
	public String getNameSpace() {
		return namespace;
	}

	/**
	 * Set the qualified name's name
	 *
	 * @param name String the qualified name's name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Set the qualified name's namespace
	 *
	 * @param namespace String the qualified name's namespace
	 */
	public void setNameSpace(String namespace) {
		this.namespace = namespace;
	}

	
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if (obj==this) {
			return true;
		}
		if (!(obj instanceof QName)) {
			return false;
		}
		QName qName = (QName) obj;
		boolean result = true;
		if (namespace!=null) {
			result = namespace.equals(qName.namespace);
		}
		if (name!=null) {
			result = name.equals(qName.name);
		}
		// TODO Auto-generated method stub
		return result;//super.equals(obj);
	}

	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return namespace.hashCode() + name.hashCode();
	}

	public String toString() {
    if (namespace!=null && !namespace.equals("")) {
			return namespace + ":" + name;
		} else {
			return name;
		}
	}
}
