/**
 * 2006-11-6
 */
package org.act.metaset.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import org.act.metaset.Attribute;
import org.act.metaset.QName;

/**
 * ʽеԪ:Ԫرʽ
 * 
 * @author cover_eye
 * 
 */
public class ElementExpression implements IExpression {
	// Ԫرʽֿռ
	private String elementNamespace = "";

	// жϸԪرʽֿռǷǰ׺ʾ
	private boolean elemPrefixFlag = true;

	// Ԫرʽ
	private String elementName = "";

	// Ԫرʽб
	private List attrList = new ArrayList();

	// ElementExpression·ָ
	public static final String SEPERATOR = "@";

	public static final String Value_SEPERATOR = "'";

	/**
	 * ñʽԪرʽ
	 * 
	 * @param eleExp
	 */
	public ElementExpression(String eleExp) {
		super();
		parse(eleExp);
	}

	/**
	 * ñʽ(ַ)н
	 * 
	 * @param eleExp
	 */
	public void parse(String eleExp) {
		Attribute attr = null;
		StringTokenizer st = new StringTokenizer(eleExp, SEPERATOR);
		if (st.hasMoreTokens()) {
			String elementStr = st.nextToken();
			int pos = elementStr.lastIndexOf(":");
			//жԪǷռ...
			if (pos >= 0) {
				// ޸:2006-11-15
				String temp = elementStr.substring(0, pos);
				int tempPos = temp.indexOf(Value_SEPERATOR);
				//жԪصռǷuri
				if (tempPos >= 0) {
					this.setElementNamespace(elementStr.substring(1, pos - 1));
					this.setElemPrefixFlag(false);
				} else
					this.setElementNamespace(elementStr.substring(0, pos));
				// this.setElementNamespace(elementStr.substring(0, pos));
				this.setElementName(elementStr.substring(pos + 1));
			} else {
				this.setElementName(elementStr);
			}
		}
		while (st.hasMoreTokens()) {
			String attrStr = st.nextToken();
			int pos = attrStr.indexOf("=");
			//жǷֵ...
			if (pos >= 0) {
				// ޸:2006-11-15
				String temp = attrStr.substring(0, pos);
				int tempPos = temp.lastIndexOf(Value_SEPERATOR);
				//жԵռǷuri
				if (tempPos >= 0) {
					QName qName = new QName(temp.substring(1, tempPos), temp
							.substring(tempPos + 2));
					attr = new Attribute(qName, attrStr.substring(pos + 2,
							attrStr.length() - 1));
					attr.setAttrPrefixFlag(false);
				} else {
					attr = new Attribute(attrStr.substring(0, pos), attrStr
							.substring(pos + 2, attrStr.length() - 1));
				}
			} else {
				//޸:2006-11-16
				int tempPos = attrStr.lastIndexOf(Value_SEPERATOR);
				//жԵռǷuri
				if (tempPos >= 0) {
					QName qName = new QName(attrStr.substring(1, tempPos),
							attrStr.substring(tempPos + 2));
					attr = new Attribute(qName, "");
					attr.setAttrPrefixFlag(false);
				} else {
					attr = new Attribute(attrStr, "");
				}

			}
			attrList.add(attr);
		}
	}

	/**
	 * 
	 * @return
	 */
	public List getAttrList() {
		return attrList;
	}

	/**
	 * 
	 * @param attrList
	 */
	public void setAttrList(List attrList) {
		this.attrList = attrList;
	}

	/**
	 * 
	 * @return
	 */
	public String getElementName() {
		return elementName;
	}

	/**
	 * 
	 * @param elementName
	 */
	public void setElementName(String elementName) {
		this.elementName = elementName;
	}

	/**
	 * 
	 * @return
	 */
	public String getElementNamespace() {
		return elementNamespace;
	}

	/**
	 * 
	 * @param elementNamespace
	 */
	public void setElementNamespace(String elementNamespace) {
		this.elementNamespace = elementNamespace;
	}

	/**
	 * 
	 * @return elemPrefixFlag
	 */
	public boolean isElemPrefixFlag() {
		return elemPrefixFlag;
	}

	/**
	 * 
	 * @param elemPrefixFlag
	 */
	public void setElemPrefixFlag(boolean elemPrefixFlag) {
		this.elemPrefixFlag = elemPrefixFlag;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		ElementExpression element = new ElementExpression(
				"'http://act.buaa.edu.cn':book@'http://xiao.org':name='java'");
		System.out.println(element.getElementNamespace());
		System.out.println(element.getElementName());
		System.out.println(element.getAttrList().get(0).toString());
	}

}
