/*
 * Created on 2005-5-18
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.act.metaset.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.act.metaset.Attribute;
import org.act.metaset.Metaset;

/**
 * class ServicesSetUtil
 * 
 * @author liujian [liujian@act.buaa.edu.cn]
 * 2005-6-23
 */
public final class MetasetUtil {
	
    public static final String getActualNamespace(Metaset set, String pre) {
        if (pre == null || pre.equals("")) {
          Metaset root = set;
          while (root.getFather() != null) {
            root = root.getFather();
          }
          //modified by cover_eye
//          return root.selector(".\\", "xmlns");
          return root.selector(root.getName()+ "@xmlns");
        }
        else {
          Metaset current = set;
          String namespace = null;
          do {
        	//modified by cover_eye  
//            namespace = current.selector(".\\", "xmlns:" + pre);
            namespace = current.selector(current.getName()+ "@xmlns:" + pre);
            if (namespace != null) {
              break;
            }
            current = current.getFather();
            if (current == null) {
              break;
            }
          } while (true);
          return namespace;
        }
      }

      public static final String getPrefix(Metaset set, String nameSpaceValue) {
        Map nameSpaceList = getNameSpaces(set);
        Iterator it = nameSpaceList.values().iterator();
        while (it.hasNext()) {
          Attribute att = (Attribute) it.next();
          if (att.getValue().equals(nameSpaceValue)) {
            return att.getName();
          }
        }
        return null;
      }

      public static final void addNameSpace(Metaset set, String name,
                                            String value) {
        Attribute att = new Attribute("xmlns:" + name, value);
        set.add(att);
      }

      public static final Map getNameSpaces(Metaset set) {
        Map nameSpaceList = new HashMap();
        for (int i = 0; i < set.getAttributes().size(); i++) {
          Attribute att = (Attribute) set.getAttributes().get(i);
          String nameSpace = att.getNameSpace();
          if (nameSpace.equals("xmlns")) {
            nameSpaceList.put(att.getName(), att);
          }
        }
        return nameSpaceList;
      }
}
